/*
 * Decompiled with CFR 0.152.
 */
package expect4j;

import expect4j.ConsumerImpl;
import expect4j.IOPair;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingConsumer
extends ConsumerImpl {
    private static final Logger logger = LoggerFactory.getLogger(BlockingConsumer.class);
    Boolean callerProcessing = Boolean.FALSE;
    boolean foundMore = false;

    public BlockingConsumer(IOPair pair) {
        super(pair);
        logger.trace("Created new BlockingConsumer instance " + this + "using IOPair " + pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BlockingConsumer blockingConsumer;
        logger.trace("BlockingConsumer " + this + " starting data processing");
        char[] cs = new char[256];
        Reader reader = this.pair.getReader();
        while (!this.stopRequested && !this.foundEOF) {
            int length;
            try {
                logger.trace("BlockingConsumer " + this + " reading from reader");
                length = reader.read(cs);
            }
            catch (IOException ioe) {
                logger.warn("Caught an exception while reading: " + ioe);
                logger.debug("Assuming EOF");
                this.foundEOF = true;
                break;
            }
            if (length == -1) {
                logger.debug("BlockingConsumer " + this + " detected EOF");
                logger.trace("Remaining buffer: " + this.buffer.toString());
                this.foundEOF = true;
                break;
            }
            logger.trace("BlockingConsumer " + this + " waiting for synchronized access before appending");
            blockingConsumer = this;
            synchronized (blockingConsumer) {
                if (logger.isDebugEnabled()) {
                    logger.debug("BlockingConsumer " + this + " appending " + length + " characters to the buffer");
                    String print = new String(cs, 0, length);
                    print = print.replaceAll("\n", "\\\\n");
                    print = print.replaceAll("\r", "\\\\r");
                    logger.debug("Adding to buffer: " + print);
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < length; ++i) {
                        sb.append("," + cs[i]);
                    }
                    logger.trace("Codes: " + sb.toString());
                }
                this.buffer.append(cs, 0, length);
                logger.trace("BlockingConsumer " + this + " notifying listeners of buffer change");
                this.notify();
            }
        }
        logger.trace("BlockingConsumer " + this + " notifying listeners upon ceasing");
        blockingConsumer = this;
        synchronized (blockingConsumer) {
            this.notify();
        }
        if (this.stopRequested) {
            logger.debug("BlockingConsumer " + this + " stop requested");
            this.pair.close();
        }
        if (this.foundEOF) {
            logger.debug("BlockingConsumer " + this + " found EOF to stop while loop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForBuffer(long timeout) {
        if (this.foundEOF) {
            logger.trace("BlockingConsumer " + this + " wanted to wait for buffer but found EOF");
            return;
        }
        logger.trace("BlockingConsumer " + this + " ynching on this to wait");
        logger.trace("BlockingConsumer " + this + " waiting for synchronized access before waiting");
        BlockingConsumer blockingConsumer = this;
        synchronized (blockingConsumer) {
            try {
                if (timeout > 0L) {
                    logger.trace("BlockingConsumer " + this + " waiting for " + timeout + " msec for some additional event");
                    this.wait(timeout);
                } else {
                    logger.trace("BlockingConsumer " + this + " waiting forever for some additional event");
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                logger.trace("BlockingConsumer " + this + " woken up while waiting for buffer");
            }
        }
    }

    @Override
    public String pause() {
        String currentBuffer = this.buffer.toString();
        return currentBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(int offset) {
        if (offset < 0) {
            return;
        }
        BlockingConsumer blockingConsumer = this;
        synchronized (blockingConsumer) {
            logger.trace("BlockingConsumer " + this + " moving buffer up by " + offset);
            StringBuffer stringBuffer = this.buffer.delete(0, offset);
        }
    }

    public static void main(String[] args) throws Exception {
        final StringBuffer buffer = new StringBuffer("The lazy fox");
        Thread t1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StringBuffer stringBuffer = buffer;
                synchronized (stringBuffer) {
                    buffer.delete(0, 4);
                    buffer.append(" in the middle");
                    System.err.println("Middle");
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    buffer.append(" of fall");
                    System.err.println("Fall");
                }
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                buffer.append(" jump over the fence");
                System.err.println("Fence");
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        System.err.println(buffer);
    }
}

