/*
 * Decompiled with CFR 0.152.
 */
package expect4j;

import expect4j.BlockingConsumer;
import expect4j.Closure;
import expect4j.Consumer;
import expect4j.ExpectState;
import expect4j.IOPair;
import expect4j.StreamPair;
import expect4j.matches.EofMatch;
import expect4j.matches.GlobMatch;
import expect4j.matches.Match;
import expect4j.matches.PatternPair;
import expect4j.matches.TimeoutMatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expect4j {
    private static final Logger logger = LoggerFactory.getLogger(Expect4j.class);
    IOPair pair;
    Consumer consumer;
    Thread consumerThread;
    Perl5Matcher matcher;
    PatternMatcherInput input;
    static final int STATE_UNINIT = 1;
    static final int STATE_INITIALIZED = 2;
    static final int STATE_EXPECTING = 3;
    static final int STATE_EXPECTED = 4;
    int mode = 1;
    public static final int RET_TRIED_ONCE = -4;
    public static final int RET_EOF = -3;
    public static final int RET_TIMEOUT = -2;
    public static final int RET_UNKNOWN = -1;
    private ExpectState g_state = null;
    public static final long TIMEOUT_NOTSET = -2L;
    public static final long TIMEOUT_FOREVER = -1L;
    public static final long TIMEOUT_NEVER = 0L;
    public static final long TIMEOUT_DEFAULT = 10000L;
    long defaultTimeout = 10000L;

    public Expect4j(IOPair pair) {
        logger.trace("Creating new Expect4J instance " + this + " using IOPair " + pair);
        this.matcher = new Perl5Matcher();
        this.matcher.setMultiline(true);
        this.input = new PatternMatcherInput("");
        this.pair = pair;
        this.consumer = new BlockingConsumer(pair);
        this.consumerThread = new Thread(this.consumer);
        this.consumerThread.setDaemon(true);
        logger.trace("Starting consumer thread " + this.consumerThread + " for Expect4J instance " + this);
        this.consumerThread.start();
        this.mode = 2;
    }

    public Expect4j(Socket socket) throws IOException {
        this(socket.getInputStream(), socket.getOutputStream());
        logger.trace("Created Expect4J instance " + this + " based on Socket " + socket);
    }

    public Expect4j(InputStream is, OutputStream os) {
        this(new StreamPair(is, os));
        logger.trace("Created Expect4J instance " + this + " based on InputStream " + is + " and OutputStream " + os);
    }

    public Expect4j(Process process) {
        this(process.getInputStream(), process.getOutputStream());
        logger.trace("Created Expect4J instance " + this + " based on Process " + process);
    }

    public void send(String data) throws IOException {
        this.consumer.send(data);
    }

    public int expect(String pattern) throws MalformedPatternException, Exception {
        logger.trace("Searching for '" + pattern + "' in the reader stream");
        return this.expect(pattern, null);
    }

    public int expect(String pattern, Closure handler) throws MalformedPatternException, Exception {
        logger.trace("Searching for '" + pattern + "' in the reader stream and executing Closure " + handler + " if found");
        GlobMatch match = new GlobMatch(pattern, handler);
        ArrayList<GlobMatch> list = new ArrayList<GlobMatch>();
        list.add(match);
        return this.expect(list);
    }

    public int expect(Match[] args) throws MalformedPatternException, Exception {
        logger.trace("Searching for " + args.length + " patterns in the reader stream");
        ArrayList<Match> pairs = new ArrayList<Match>();
        for (int i = 0; i < args.length; ++i) {
            Match match = args[i];
            pairs.add(match);
        }
        return this.expect(pairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int expect(List pairs) throws Exception {
        logger.trace("Searching for " + pairs.size() + " patterns in the reader stream");
        EofMatch eofMatch = null;
        TimeoutMatch timeoutMatch = null;
        ArrayList patternMatches = new ArrayList();
        for (Object match : pairs) {
            if (!(match instanceof Match)) {
                logger.debug("Object " + match + " is not of type expect4j.matches.Match, cannot use as a pattern");
                continue;
            }
            if (match instanceof PatternPair) {
                logger.trace("Searching for PatternPair " + match + " in the reader stream");
                patternMatches.add(match);
                continue;
            }
            if (match instanceof TimeoutMatch) {
                logger.trace("Registering custom TimeoutMatch handler " + match);
                timeoutMatch = (TimeoutMatch)match;
                continue;
            }
            if (match instanceof EofMatch) {
                logger.trace("Registering custom EofMatch handler " + match);
                eofMatch = (EofMatch)match;
                continue;
            }
            logger.debug("Unexpected match object " + match + " found in the pattern list, ignoring");
        }
        long timeout = timeoutMatch != null && timeoutMatch.getTimeout() != -2L ? timeoutMatch.getTimeout() : this.defaultTimeout;
        long startTime = System.currentTimeMillis();
        long endTime = startTime + timeout;
        logger.debug("Timeout set to " + timeout + " milliseconds, expires at " + endTime);
        boolean foundTimeout = false;
        boolean foundEof = false;
        int index = -1;
        this.g_state = null;
        String toMatch = null;
        while (true) {
            if (timeout != -1L && System.currentTimeMillis() >= endTime) {
                logger.debug("Detection timeout expired");
                foundTimeout = true;
                break;
            }
            Consumer consumer = this.consumer;
            synchronized (consumer) {
                toMatch = this.consumer.pause();
                logger.trace("Size of toMatch is " + toMatch.length());
                foundEof = this.consumer.foundEOF();
                this.input.setInput(toMatch);
                logger.debug("Finding first match using >>>" + this.printBuffer() + "<<< as the haystack");
                boolean foundMatch = false;
                try {
                    foundMatch = this.runFirstMatch(patternMatches);
                }
                catch (Exception e) {
                    logger.warn("Forwarding an exception that occurred in a Closure: " + e);
                    this.consumer.resume();
                    throw e;
                }
                if (foundMatch) {
                    int matchedWhere = this.g_state.getMatchedWhere();
                    int matchedLength = this.g_state.getMatch().length();
                    logger.debug("Matched @ " + matchedWhere + " with a length of " + matchedLength);
                    this.consumer.resume(matchedWhere + matchedLength);
                    PatternPair singlepair = (PatternPair)patternMatches.get(this.g_state.getPairIndex());
                    logger.trace("Pair found " + singlepair.getPattern().getPattern());
                    index = pairs.indexOf(singlepair);
                    logger.trace("Index found " + index);
                    if (!this.g_state.shouldContinue()) {
                        logger.trace("NOT Continuing");
                        break;
                    }
                    logger.trace("Continuing");
                    if (this.g_state.shouldResetTimer()) {
                        endTime = System.currentTimeMillis() + timeout;
                    }
                    continue;
                }
                logger.trace("Nothing found, resuming consumer");
                this.consumer.resume();
                if (timeout == 0L) {
                    index = -4;
                    break;
                }
                if (foundEof) {
                    logger.debug("Found EOF");
                    break;
                }
                if (timeout == -1L) {
                    this.consumer.waitForBuffer(-1L);
                } else {
                    long singleTimeout = endTime - System.currentTimeMillis();
                    logger.trace("singleTimeout: " + singleTimeout);
                    if (timeout != -1L && singleTimeout <= 0L) {
                        continue;
                    }
                    logger.debug("Waiting for more input");
                    this.consumer.waitForBuffer(singleTimeout);
                }
            }
        }
        logger.trace("Leaving main while loop");
        Match lastmile = null;
        String lastmileBuffer = null;
        if (foundTimeout) {
            logger.trace("Dealing with Timeout");
            if (timeoutMatch == null) {
                index = -2;
            } else {
                lastmile = timeoutMatch;
            }
        }
        if (foundEof) {
            logger.info("Dealing with EOF " + eofMatch);
            if (eofMatch != null) {
                lastmileBuffer = toMatch;
                lastmile = eofMatch;
            } else if (index == -1) {
                index = -3;
            }
        }
        if (lastmile != null) {
            logger.trace("Running last mile");
            Closure closure = lastmile.getClosure();
            index = pairs.indexOf(lastmile);
            ExpectState state = this.prepareClosure(index, lastmileBuffer);
            try {
                if (closure != null) {
                    closure.run(state);
                }
            }
            catch (Exception e) {
                logger.warn("Forwarding an exception that occurred in a Closure: " + e);
                logger.trace("Closure body: " + closure.toString());
                throw e;
            }
            finally {
                this.g_state = state;
            }
        }
        return index;
    }

    protected String printBuffer() {
        String javaStr = new String(this.input.getBuffer());
        javaStr = javaStr.replaceAll("\\r", "\\\\r");
        javaStr = javaStr.replaceAll("\\n", "\\\\n");
        return javaStr;
    }

    protected ExpectState prepareClosure(int pairIndex, String buffer) {
        Map prevMap = null;
        if (this.g_state != null) {
            prevMap = this.g_state.getVars();
        }
        ExpectState state = new ExpectState(pairIndex, buffer, prevMap);
        return state;
    }

    protected ExpectState prepareClosure(int pairIndex, MatchResult result) {
        Map prevMap = null;
        if (this.g_state != null) {
            prevMap = this.g_state.getVars();
        }
        int matchedWhere = result.beginOffset(0);
        String matchedText = result.toString();
        char[] chBuffer = this.input.getBuffer();
        String copyBuffer = new String(chBuffer, 0, result.endOffset(0));
        ArrayList<String> groups = new ArrayList<String>();
        for (int j = 1; j <= result.groups(); ++j) {
            String group = result.group(j);
            groups.add(group);
        }
        ExpectState state = new ExpectState(copyBuffer.toString(), matchedWhere, matchedText, pairIndex, groups, prevMap);
        return state;
    }

    protected boolean runFirstMatch(List pairs) throws Exception {
        MatchResult firstResult = null;
        PatternPair firstPair = null;
        int pairIndex = -1;
        ListIterator iter = pairs.listIterator();
        while (iter.hasNext()) {
            PatternPair pair = (PatternPair)iter.next();
            Pattern pattern = pair.getPattern();
            this.input.setCurrentOffset(this.input.getBeginOffset());
            if (!this.matcher.contains(this.input, pattern)) continue;
            MatchResult result = this.matcher.getMatch();
            if (firstResult != null && result.beginOffset(0) >= firstResult.beginOffset(0)) continue;
            firstResult = result;
            firstPair = pair;
            pairIndex = iter.previousIndex();
        }
        if (firstResult == null) {
            return false;
        }
        logger.trace("Using a result for " + firstPair.getPattern().getPattern());
        ExpectState state = this.prepareClosure(pairIndex, firstResult);
        Closure closure = firstPair.getClosure();
        try {
            if (closure != null) {
                closure.run(state);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.g_state = state;
        }
        return true;
    }

    public ExpectState getLastState() {
        return this.g_state != null ? this.g_state : new ExpectState();
    }

    public void setDefaultTimeout(long timeout) {
        logger.debug("Setting default timeout to " + timeout);
        this.defaultTimeout = timeout;
    }

    protected TimeoutMatch findTimeout(Match[] matches) {
        TimeoutMatch ourTimeout = null;
        for (int i = 0; i < matches.length; ++i) {
            if (!(matches[i] instanceof TimeoutMatch)) continue;
            ourTimeout = (TimeoutMatch)matches[i];
        }
        return ourTimeout;
    }

    protected EofMatch findEof(Match[] matches) {
        EofMatch ourEof = null;
        for (int i = 0; i < matches.length; ++i) {
            if (!(matches[i] instanceof EofMatch)) continue;
            ourEof = (EofMatch)matches[i];
        }
        if (ourEof == null) {
            ourEof = new EofMatch();
        }
        return ourEof;
    }

    public void close() {
        logger.debug("Stopping processing of the reader/writer streams by the Expect4j instance" + this);
        this.consumer.stop();
    }
}

