/*
 * Decompiled with CFR 0.152.
 */
package expect4j;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import expect4j.Closure;
import expect4j.Expect4j;
import expect4j.ExpectState;
import expect4j.StreamPair;
import expect4j.matches.EofMatch;
import expect4j.matches.Match;
import expect4j.matches.RegExpMatch;
import expect4j.matches.TimeoutMatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Hashtable;
import org.apache.commons.net.io.FromNetASCIIInputStream;
import org.apache.commons.net.io.ToNetASCIIOutputStream;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExpectUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExpectUtils.class);

    public static String Http(String remotehost, String url) throws Exception {
        Socket s = null;
        s = new Socket(remotehost, 80);
        logger.debug("Connected to " + s.getInetAddress().toString());
        Expect4j expect = new Expect4j(s);
        logger.debug("Sending HTTP request for " + url);
        expect.send("GET " + url + " HTTP/1.1\r\n");
        expect.send("Host: " + remotehost + "\r\n");
        expect.send("Connection: close\r\n");
        expect.send("User-Agent: Expect4j\r\n");
        expect.send("\r\n");
        logger.debug("Waiting for HTTP response");
        String remaining = null;
        expect.expect(new Match[]{new RegExpMatch("HTTP/1.[01] \\d{3} (.*)\n?\r", new Closure(){

            @Override
            public void run(ExpectState state) {
                logger.trace("Detected HTTP Response Header");
                String match = state.getMatch();
                String[] parts = match.split(" ");
                state.addVar("httpCode", parts[1]);
                state.exp_continue();
            }
        }), new RegExpMatch("Content-Type: (.*\\/.*)\r\n", new Closure(){

            @Override
            public void run(ExpectState state) {
                logger.trace("Detected Content-Type header");
                state.addVar("contentType", state.getMatch());
                state.exp_continue();
            }
        }), new EofMatch(new Closure(){

            @Override
            public void run(ExpectState state) {
                logger.trace("Found EOF, done receiving HTTP response");
            }
        }), new TimeoutMatch(10000L, new Closure(){

            @Override
            public void run(ExpectState state) {
                logger.trace("Timeout waiting for HTTP response");
            }
        })});
        remaining = expect.getLastState().getBuffer();
        String httpCode = (String)expect.getLastState().getVar("httpCode");
        String contentType = (String)expect.getLastState().getVar("contentType");
        s.close();
        return remaining;
    }

    public static Expect4j SSH(String hostname, String username, String password) throws Exception {
        return ExpectUtils.SSH(hostname, username, password, 22);
    }

    public static Expect4j SSH(String hostname, String username, String password, int port) throws Exception {
        logger.debug("Creating SSH session with " + hostname + ":" + port + " as " + username);
        JSch jsch = new JSch();
        Session session = jsch.getSession(username, hostname, port);
        if (password != null) {
            logger.trace("Setting the Jsch password to the one provided (not shown)");
            session.setPassword(password);
        }
        Hashtable<String, String> config = new Hashtable<String, String>();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.setDaemonThread(true);
        session.connect(3000);
        ChannelShell channel = (ChannelShell)session.openChannel("shell");
        channel.setPtyType("vt102");
        Hashtable env = new Hashtable();
        channel.setEnv(env);
        Expect4j expect = new Expect4j(channel.getInputStream(), channel.getOutputStream());
        channel.connect(5000);
        return expect;
    }

    public static Expect4j telnet(String hostname, int port) throws Exception {
        final TelnetClient client = new TelnetClient();
        TerminalTypeOptionHandler ttopt = new TerminalTypeOptionHandler("VT100", false, false, true, true);
        EchoOptionHandler echoopt = new EchoOptionHandler(true, false, true, false);
        SuppressGAOptionHandler gaopt = new SuppressGAOptionHandler(false, false, false, false);
        client.addOptionHandler((TelnetOptionHandler)ttopt);
        client.addOptionHandler((TelnetOptionHandler)echoopt);
        client.addOptionHandler((TelnetOptionHandler)gaopt);
        client.connect(hostname, port);
        FromNetASCIIInputStream is = new FromNetASCIIInputStream(client.getInputStream());
        ToNetASCIIOutputStream os = new ToNetASCIIOutputStream(client.getOutputStream());
        StreamPair pair = new StreamPair((InputStream)is, (OutputStream)os){

            @Override
            public void close() {
                try {
                    if (client != null) {
                        client.disconnect();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Expect4j expect4j = new Expect4j(pair);
        return expect4j;
    }

    public static Expect4j spawn(String cmdLine) throws Exception {
        return ExpectUtils.spawn(cmdLine, null);
    }

    public static Expect4j spawn(String cmdLine, String[] envParams) throws Exception {
        String[] cmdArgs = cmdLine.split(" ");
        return ExpectUtils.spawn(cmdArgs, envParams);
    }

    public static Expect4j spawn(String[] cmdArgs) throws Exception {
        return ExpectUtils.spawn(cmdArgs, null);
    }

    public static Expect4j spawn(String[] cmdArgs, String[] envParams) throws Exception {
        Process process = Runtime.getRuntime().exec(cmdArgs, envParams);
        Expect4j expect = new Expect4j(process);
        return expect;
    }
}

