/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import com.github.danielflower.mavenplugins.gitlog.renderers.FileRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.Formatter;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;

public class PlainTextRenderer
extends FileRenderer {
    private boolean previousWasTag = false;
    private final boolean fullGitMessage;

    public PlainTextRenderer(Log log, File targetFolder, String filename, boolean fullGitMessage) throws IOException {
        super(log, targetFolder, filename);
        this.fullGitMessage = fullGitMessage;
    }

    @Override
    public void renderHeader(String reportTitle) throws IOException {
        if (reportTitle != null && reportTitle.length() > 0) {
            this.writer.write(reportTitle);
            this.writer.write(Formatter.NEW_LINE);
            this.writer.write(Formatter.NEW_LINE);
        }
    }

    @Override
    public void renderTag(RevTag tag) throws IOException {
        if (!this.previousWasTag) {
            this.writer.write(Formatter.NEW_LINE);
        }
        this.writer.write(tag.getTagName());
        this.writer.write(Formatter.NEW_LINE);
        this.previousWasTag = true;
    }

    @Override
    public void renderCommit(RevCommit commit) throws IOException {
        String message = null;
        message = this.fullGitMessage ? commit.getFullMessage() : commit.getShortMessage();
        this.writer.write(Formatter.formatDateTime(commit.getCommitTime()) + "    " + message);
        this.writer.write(" (" + commit.getCommitterIdent().getName() + ")");
        this.writer.write(Formatter.NEW_LINE);
        this.previousWasTag = false;
    }

    @Override
    public void renderFooter() throws IOException {
    }
}

