/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb;

import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import metrics_influxdb.HttpInfluxdbProtocol;
import metrics_influxdb.InfluxdbProtocol;
import metrics_influxdb.UdpInfluxdbProtocol;
import metrics_influxdb.api.measurements.MetricMeasurementTransformer;
import metrics_influxdb.measurements.HttpInlinerSender;
import metrics_influxdb.measurements.MeasurementReporter;
import metrics_influxdb.measurements.Sender;
import metrics_influxdb.measurements.UdpInlinerSender;
import metrics_influxdb.misc.HttpDatabaseCreator;
import metrics_influxdb.misc.Miscellaneous;
import metrics_influxdb.v08.Influxdb;
import metrics_influxdb.v08.InfluxdbHttp;
import metrics_influxdb.v08.InfluxdbUdp;
import metrics_influxdb.v08.ReporterV08;

public class InfluxdbReporter {
    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private boolean autoCreateDB;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private boolean skipIdleMetrics;
        private ScheduledExecutorService executor;
        InfluxdbCompatibilityVersions influxdbVersion;
        InfluxdbProtocol protocol;
        Influxdb influxdbDelegate;
        Map<String, String> tags;
        MetricMeasurementTransformer transformer = MetricMeasurementTransformer.NOOP;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.protocol = new HttpInfluxdbProtocol();
            this.influxdbVersion = InfluxdbCompatibilityVersions.LATEST;
            this.tags = new HashMap<String, String>();
            this.autoCreateDB = true;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder withAutoCreateDB(boolean autocreate) {
            this.autoCreateDB = autocreate;
            return this;
        }

        public Builder withScheduler(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder skipIdleMetrics(boolean skipIdleMetrics) {
            this.skipIdleMetrics = skipIdleMetrics;
            return this;
        }

        public ScheduledReporter build() {
            ScheduledReporter reporter;
            switch (this.influxdbVersion) {
                case V08: {
                    Influxdb influxdb = this.buildInfluxdb();
                    reporter = this.executor == null ? new ReporterV08(this.registry, influxdb, this.clock, this.prefix, this.rateUnit, this.durationUnit, this.filter, this.skipIdleMetrics) : new ReporterV08(this.registry, influxdb, this.clock, this.prefix, this.rateUnit, this.durationUnit, this.filter, this.skipIdleMetrics, this.executor);
                    break;
                }
                default: {
                    Sender s = this.buildSender();
                    reporter = this.executor == null ? new MeasurementReporter(s, this.registry, this.filter, this.rateUnit, this.durationUnit, this.clock, this.tags, this.transformer) : new MeasurementReporter(s, this.registry, this.filter, this.rateUnit, this.durationUnit, this.clock, this.tags, this.transformer, this.executor);
                }
            }
            return reporter;
        }

        public Builder v08() {
            this.influxdbVersion = InfluxdbCompatibilityVersions.V08;
            return this;
        }

        public Builder protocol(InfluxdbProtocol protocol) {
            Objects.requireNonNull(protocol, "given InfluxdbProtocol cannot be null");
            this.protocol = protocol;
            return this;
        }

        public Builder transformer(MetricMeasurementTransformer transformer) {
            Objects.requireNonNull(transformer, "given MetricMeasurementTransformer cannot be null");
            this.transformer = transformer;
            return this;
        }

        public Builder tag(String tagKey, String tagValue) {
            Miscellaneous.requireNotEmptyParameter(tagKey, "tag");
            Miscellaneous.requireNotEmptyParameter(tagValue, "value");
            this.tags.put(tagKey, tagValue);
            return this;
        }

        private Influxdb buildInfluxdb() {
            if (this.protocol instanceof HttpInfluxdbProtocol) {
                try {
                    HttpInfluxdbProtocol p = (HttpInfluxdbProtocol)this.protocol;
                    return new InfluxdbHttp(p.scheme, p.host, p.port, p.database, p.user, p.password, this.durationUnit);
                }
                catch (RuntimeException exc) {
                    throw exc;
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc.getMessage(), exc);
                }
            }
            if (this.protocol instanceof UdpInfluxdbProtocol) {
                UdpInfluxdbProtocol p = (UdpInfluxdbProtocol)this.protocol;
                return new InfluxdbUdp(p.host, p.port);
            }
            throw new IllegalStateException("unsupported protocol: " + this.protocol);
        }

        private Sender buildSender() {
            if (this.protocol instanceof HttpInfluxdbProtocol) {
                HttpInfluxdbProtocol httpInfluxdbProtocol = (HttpInfluxdbProtocol)this.protocol;
                if (this.autoCreateDB) {
                    HttpDatabaseCreator.run(httpInfluxdbProtocol);
                }
                return new HttpInlinerSender(httpInfluxdbProtocol);
            }
            if (this.protocol instanceof UdpInfluxdbProtocol) {
                return new UdpInlinerSender((UdpInfluxdbProtocol)this.protocol);
            }
            throw new IllegalStateException("unsupported protocol: " + this.protocol);
        }
    }

    static enum InfluxdbCompatibilityVersions {
        V08,
        LATEST;

    }
}

