/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb.misc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import metrics_influxdb.HttpInfluxdbProtocol;
import metrics_influxdb.misc.Miscellaneous;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpDatabaseCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDatabaseCreator.class);

    public static void run(HttpInfluxdbProtocol protocol) {
        URL toJoin;
        try {
            toJoin = protocol.secured ? new URL(protocol.scheme, protocol.host, protocol.port, "/query&u=" + Miscellaneous.urlEncode(protocol.user) + "&p=" + Miscellaneous.urlEncode(protocol.password)) : new URL(protocol.scheme, protocol.host, protocol.port, "/query");
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            toJoin = null;
        }
        String database = protocol.database;
        URL queryUrl = toJoin;
        try {
            HttpURLConnection con = (HttpURLConnection)queryUrl.openConnection();
            con.setRequestMethod("GET");
            con.setConnectTimeout(Long.valueOf(TimeUnit.SECONDS.toMillis(2L)).intValue());
            con.setReadTimeout(Long.valueOf(TimeUnit.SECONDS.toMillis(2L)).intValue());
            con.setDoOutput(true);
            OutputStream wr = con.getOutputStream();
            wr.write(("q=CREATE DATABASE " + database).getBytes());
            wr.flush();
            wr.close();
        }
        catch (IOException e) {
            LOGGER.warn("Tried to create database, but failed.", (Throwable)e);
        }
    }
}

