/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb.serialization.line;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import metrics_influxdb.measurements.Measure;
import metrics_influxdb.misc.Miscellaneous;
import metrics_influxdb.serialization.line.InfluxDBSortedMap;

public class Inliner {
    private static char[] ESCAPE_CHARS = new char[]{' ', ',', '='};
    private TimeUnit precision;

    public Inliner(TimeUnit precision) {
        this.precision = precision;
    }

    public String inline(Measure m) {
        String key = this.buildMeasureKey(m.getName(), m.getTags());
        String values = this.buildMeasureFields(m.getValues());
        String timestamp = "" + this.precision.convert(m.getTimestamp(), TimeUnit.MILLISECONDS);
        return key + " " + values + " " + timestamp;
    }

    public String inline(Iterable<Measure> measures) {
        StringBuilder sb = new StringBuilder();
        String join = "";
        String cr = "\n";
        for (Measure m : measures) {
            sb.append(join).append(this.inline(m));
            join = cr;
        }
        return sb.toString();
    }

    private String buildMeasureFields(Map<String, String> values) {
        InfluxDBSortedMap sortedValues = new InfluxDBSortedMap();
        sortedValues.putAll(values);
        StringBuilder fields = new StringBuilder();
        String join = "";
        for (Map.Entry v : sortedValues.entrySet()) {
            fields.append(join).append(Miscellaneous.escape((String)v.getKey(), ESCAPE_CHARS)).append("=").append((String)v.getValue());
            join = ",";
        }
        return fields.toString();
    }

    private String buildMeasureKey(String name, Map<String, String> tags) {
        StringBuilder key = new StringBuilder(Miscellaneous.escape(name, ESCAPE_CHARS));
        InfluxDBSortedMap sortedTags = new InfluxDBSortedMap();
        sortedTags.putAll(tags);
        for (Map.Entry e : sortedTags.entrySet()) {
            key.append(',').append(Miscellaneous.escape((String)e.getKey(), ESCAPE_CHARS)).append("=").append(Miscellaneous.escape((String)e.getValue(), ESCAPE_CHARS));
        }
        return key.toString();
    }
}

