/*
 * Decompiled with CFR 0.152.
 */
package com.github.devmix.esb.car.plugin.builders;

import com.github.devmix.esb.car.plugin.builders.ArtifactsListBuilder;
import com.github.devmix.esb.car.plugin.registry.SynapseArtifactTypesBundle;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.utils.StringUtils;

abstract class AbstractArtifactsBuilder<B> {
    protected ArtifactsListBuilder artifactsList;
    protected String outputDirectory;
    protected String configDir;
    protected String serverRole;
    protected String version;
    protected SynapseArtifactTypesBundle artifactTypes;

    AbstractArtifactsBuilder() {
    }

    public B artifactsList(ArtifactsListBuilder artifactsList) {
        this.artifactsList = artifactsList;
        return (B)this;
    }

    public B outputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
        return (B)this;
    }

    public B configDir(String configDir) {
        this.configDir = configDir;
        return (B)this;
    }

    public B serverRole(String serverRole) {
        this.serverRole = serverRole;
        return (B)this;
    }

    public B version(String version) {
        this.version = version;
        return (B)this;
    }

    public B artifactTypes(SynapseArtifactTypesBundle artifactTypes) {
        this.artifactTypes = artifactTypes;
        return (B)this;
    }

    protected void check() throws MojoFailureException {
        if (StringUtils.isBlank((String)this.outputDirectory)) {
            throw new MojoFailureException("outputDirectory is empty");
        }
        if (StringUtils.isBlank((String)this.configDir)) {
            throw new MojoFailureException("configDir is empty");
        }
        if (StringUtils.isBlank((String)this.serverRole)) {
            throw new MojoFailureException("serverRole is empty");
        }
        if (StringUtils.isBlank((String)this.version)) {
            throw new MojoFailureException("version is empty");
        }
    }
}

