/*
 * Decompiled with CFR 0.152.
 */
package com.github.devmix.esb.car.plugin.builders;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public final class ArtifactsListBuilder {
    public static final Comparator<Dependency> DEPENDENCY_COMPARATOR = new Comparator<Dependency>(){

        @Override
        public int compare(Dependency o1, Dependency o2) {
            return Integer.compare(o1.priority, o2.priority);
        }
    };
    private final List<Dependency> list = new LinkedList<Dependency>();

    public void add(String artifactName, String version, String serverRole, boolean include, int priority) {
        this.list.add(new Dependency(artifactName, version, serverRole, include, priority));
    }

    public List<Dependency> ordered() {
        Collections.sort(this.list, DEPENDENCY_COMPARATOR);
        return Collections.unmodifiableList(this.list);
    }

    public String toString() {
        return "ArtifactsListBuilder{" + this.list + '}';
    }

    public static final class Dependency {
        public final String artifactName;
        public final String version;
        public final String serverRole;
        public final boolean include;
        public final int priority;

        private Dependency(String artifactName, String version, String serverRole, boolean include, int priority) {
            this.artifactName = artifactName;
            this.version = version;
            this.serverRole = serverRole;
            this.include = include;
            this.priority = priority;
        }

        public String toString() {
            return "Dependency{artifactName='" + this.artifactName + '\'' + ", version='" + this.version + '\'' + ", serverRole='" + this.serverRole + '\'' + ", include=" + this.include + ", priority=" + this.priority + '}';
        }
    }
}

