/*
 * Decompiled with CFR 0.152.
 */
package com.github.devmix.esb.car.plugin.builders;

import com.github.devmix.esb.car.plugin.builders.AbstractArtifactsBuilder;
import com.github.devmix.esb.car.plugin.builders.XmlBuilder;
import com.github.devmix.esb.car.plugin.utils.CommonUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.MojoFailureException;

public final class SynapseConfigArtifactsBuilder
extends AbstractArtifactsBuilder<SynapseConfigArtifactsBuilder> {
    private SynapseConfigArtifactsBuilder() {
    }

    public static SynapseConfigArtifactsBuilder newInstance() {
        return new SynapseConfigArtifactsBuilder();
    }

    public void build() throws MojoFailureException {
        this.check();
        try {
            this.createArtifacts();
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void createArtifacts() throws IOException, MojoFailureException {
        Path sourcesDir = Paths.get(this.configDir, new String[0]);
        if (!Files.exists(sourcesDir, new LinkOption[0])) {
            return;
        }
        Files.createDirectories(Paths.get(this.outputDirectory, new String[0]), new FileAttribute[0]);
        try (DirectoryStream<Path> confStream = Files.newDirectoryStream(sourcesDir);){
            for (Path path : confStream) {
                String type = path.getFileName().toString();
                this.createArtifactsOf(type, path);
            }
        }
    }

    private void createArtifactsOf(String type, Path fromPath) throws IOException, MojoFailureException {
        if (this.artifactTypes.isNotSupported(type)) {
            throw new MojoFailureException("Unsupported type of artifact - " + type);
        }
        try (DirectoryStream<Path> artifactStream = Files.newDirectoryStream(fromPath);){
            for (Path file : artifactStream) {
                this.createArtifactOf(type, file);
            }
        }
    }

    private void createArtifactOf(String type, Path fromFile) throws IOException, MojoFailureException {
        String fileName = fromFile.getFileName().toString();
        String artifactExt = CommonUtils.extensionOf(fileName);
        String artifactName = CommonUtils.removeFileExtension(fileName);
        String artifactFileName = artifactName + "-" + this.version + "." + artifactExt;
        Path artifactDir = Paths.get(this.outputDirectory, artifactName + "_" + this.version);
        Path artifactFile = Paths.get(artifactDir.toString(), artifactFileName);
        Path artifactMetaFile = Paths.get(artifactDir.toString(), "artifact.xml");
        if (!Files.exists(artifactDir, new LinkOption[0])) {
            Files.createDirectory(artifactDir, new FileAttribute[0]);
        }
        Files.copy(fromFile, artifactFile, StandardCopyOption.REPLACE_EXISTING);
        try {
            String xml = new XmlBuilder().node("artifact").attr("name", artifactName).attr("version", this.version).attr("type", this.artifactTypes.of(type).getType()).attr("serverRole", this.serverRole).node("file").content(artifactFileName).builder().asString();
            try (FileOutputStream fis = new FileOutputStream(artifactMetaFile.toFile());){
                fis.write(xml.getBytes());
            }
        }
        catch (XmlBuilder.XmlBuildException e) {
            throw new MojoFailureException("Can't create artifact.xml", (Throwable)e);
        }
        this.artifactsList.add(artifactName, this.version, this.serverRole, true, this.artifactTypes.of(type).getPriority());
    }
}

