/*
 * Decompiled with CFR 0.152.
 */
package com.github.devmix.esb.car.plugin.builders;

import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XmlBuilder {
    private final Node root = new Node(null, "root");

    public String asString() throws XmlBuildException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            this.root.createTo(null, document);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter output = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(output));
            return output.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XmlBuildException(e);
        }
    }

    public Node node(String name) {
        return this.root.node(name);
    }

    public static final class XmlBuildException
    extends Exception {
        public XmlBuildException(Throwable throwable) {
            super(throwable);
        }
    }

    public final class Content {
        private final String text;
        private final Node owner;

        public Content(String text, Node owner) {
            this.text = text;
            this.owner = owner;
        }

        public Node parent() {
            return this.owner.parent();
        }

        public XmlBuilder builder() {
            return XmlBuilder.this;
        }
    }

    public final class Attr {
        private final Node owner;
        private final String name;
        private final String value;

        public Attr(Node owner, String name, String value) {
            this.owner = owner;
            this.name = name;
            this.value = value;
        }

        public Attr attr(String name, String value) {
            return this.owner.attr(name, value);
        }

        public Node node(String name) {
            return this.owner.node(name);
        }

        public Node node() {
            return this.owner;
        }
    }

    public final class Node {
        private final Node owner;
        private final List<Node> nodes = new LinkedList<Node>();
        private final List<Attr> attrs = new LinkedList<Attr>();
        private final String name;
        @Nullable
        private Content content;

        public Node(Node owner, String name) {
            this.owner = owner;
            this.name = name;
        }

        public Attr attr(String name, String value) {
            Attr attr = new Attr(this, name, value);
            this.attrs.add(attr);
            return new Attr(this, name, value);
        }

        public Node node(String name) {
            Node node = new Node(this, name);
            this.nodes.add(node);
            return node;
        }

        public Node parent() {
            return this.owner;
        }

        public XmlBuilder builder() {
            return XmlBuilder.this;
        }

        public Content content(String text) {
            this.content = new Content(text, this);
            return this.content;
        }

        public void createTo(@Nullable Element element, Document document) {
            if (this == XmlBuilder.this.root) {
                for (Node node : this.nodes) {
                    node.createTo(null, document);
                }
            } else {
                Element e = document.createElement(this.name);
                if (element == null) {
                    document.appendChild(e);
                } else {
                    element.appendChild(e);
                }
                for (Attr attr : this.attrs) {
                    e.setAttribute(attr.name, attr.value);
                }
                if (this.content != null) {
                    e.setTextContent(this.content.text);
                }
                for (Node node : this.nodes) {
                    node.createTo(e, document);
                }
            }
        }
    }
}

