/*
 * Decompiled with CFR 0.152.
 */
package com.github.devmix.esb.car.plugin.registry;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.github.devmix.esb.car.plugin.utils.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public final class SynapseArtifactTypesBundle {
    private static final Log log = new SystemStreamLog();
    private static final Meta NULL = new Meta();
    private static final MapType TYPE = MapType.construct(LinkedHashMap.class, (JavaType)SimpleType.construct(String.class), (JavaType)SimpleType.construct(Meta.class));
    private final Map<String, Meta> list = new LinkedHashMap<String, Meta>();

    public SynapseArtifactTypesBundle putTypes(String file) {
        ObjectMapper mapper = CommonUtils.mapperOf(file);
        try {
            Map map = (Map)mapper.readValue(new File(file), (JavaType)TYPE);
            this.list.putAll(map);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        return this;
    }

    public SynapseArtifactTypesBundle putTypes(URL file) {
        ObjectMapper mapper = CommonUtils.mapperOf(file.getFile());
        try {
            Map map = (Map)mapper.readValue(file, (JavaType)TYPE);
            this.list.putAll(map);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        return this;
    }

    public Meta of(String type) {
        Meta meta = this.list.get(type);
        return meta == null ? NULL : meta;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isNotSupported(String type) {
        return !this.list.containsKey(type);
    }

    public static final class Meta {
        private String type;
        private int priority;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }
    }
}

