/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs.async;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.core.async.ResponseStreamProcessor;
import com.github.dockerjava.jaxrs.util.WrappedResponseInputStream;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;

public abstract class AbstractCallbackNotifier<T>
implements Callable<Void> {
    private final ResponseStreamProcessor<T> responseStreamProcessor;
    private final ResultCallback<T> resultCallback;
    protected final Invocation.Builder requestBuilder;

    protected AbstractCallbackNotifier(ResponseStreamProcessor<T> responseStreamProcessor, ResultCallback<T> resultCallback, Invocation.Builder requestBuilder) {
        Preconditions.checkNotNull((Object)requestBuilder, (Object)"An WebTarget must be provided");
        Preconditions.checkNotNull(responseStreamProcessor, (Object)"A ResponseStreamProcessor must be provided");
        this.responseStreamProcessor = responseStreamProcessor;
        this.resultCallback = resultCallback;
        this.requestBuilder = requestBuilder;
    }

    @Override
    public Void call() throws Exception {
        Response response = null;
        try {
            response = this.response();
        }
        catch (ProcessingException e) {
            if (this.resultCallback != null) {
                this.resultCallback.onError(e.getCause());
            }
            return null;
        }
        catch (Exception e) {
            if (this.resultCallback != null) {
                this.resultCallback.onError(e);
            }
            return null;
        }
        try {
            WrappedResponseInputStream inputStream = new WrappedResponseInputStream(response);
            if (this.resultCallback != null) {
                this.responseStreamProcessor.processResponseStream(inputStream, this.resultCallback);
            }
            return null;
        }
        catch (Exception e) {
            if (this.resultCallback != null) {
                this.resultCallback.onError(e);
            }
            return null;
        }
    }

    protected abstract Response response();

    public static <T> Future<Void> startAsyncProcessing(AbstractCallbackNotifier<T> callbackNotifier) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Void> response = executorService.submit(callbackNotifier);
        executorService.shutdown();
        return response;
    }
}

