/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.DockerClientException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.core.AuthConfigFile;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.SSLConfig;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DockerClientConfig
implements Serializable {
    private static final long serialVersionUID = -4307357472441531489L;
    private static final String DOCKER_HOST_PROPERTY = "DOCKER_HOST";
    private static final String DOCKER_CERT_PATH_PROPERTY = "DOCKER_CERT_PATH";
    private static final String DOCKER_VERIFY_TLS_PROPERTY = "DOCKER_TLS_VERIFY";
    private static final String DOCKER_IO_URL_PROPERTY = "docker.io.url";
    private static final String DOCKER_IO_VERSION_PROPERTY = "docker.io.version";
    private static final String DOCKER_IO_USERNAME_PROPERTY = "docker.io.username";
    private static final String DOCKER_IO_PASSWORD_PROPERTY = "docker.io.password";
    private static final String DOCKER_IO_EMAIL_PROPERTY = "docker.io.email";
    private static final String DOCKER_IO_SERVER_ADDRESS_PROPERTY = "docker.io.serverAddress";
    private static final String DOCKER_IO_DOCKER_CERT_PATH_PROPERTY = "docker.io.dockerCertPath";
    private static final String DOCKER_IO_DOCKER_CFG_PATH_PROPERTY = "docker.io.dockerCfgPath";
    private static final Map<String, String> ENV_NAME_TO_IO_NAME;
    private static final String DOCKER_IO_PROPERTIES_PROPERTY = "docker.io.properties";
    private final URI uri;
    private final String username;
    private final String password;
    private final String email;
    private final String serverAddress;
    private final String dockerCfgPath;
    private final RemoteApiVersion version;
    private final SSLConfig sslConfig;

    DockerClientConfig(URI uri, String version, String username, String password, String email, String serverAddress, String dockerCfgPath, SSLConfig sslConfig) {
        this.uri = uri;
        this.version = RemoteApiVersion.parseConfigWithDefault(version);
        this.username = username;
        this.password = password;
        this.email = email;
        this.serverAddress = serverAddress;
        this.dockerCfgPath = dockerCfgPath;
        this.sslConfig = sslConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadIncludedDockerProperties(Properties systemProperties) {
        try (InputStream is = DockerClientConfig.class.getResourceAsStream("/docker.io.properties");){
            Properties p = new Properties();
            p.load(is);
            DockerClientConfig.replaceProperties(p, systemProperties);
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void replaceProperties(Properties properties, Properties replacements) {
        for (Object objectKey : properties.keySet()) {
            String key = objectKey.toString();
            properties.setProperty(key, DockerClientConfig.replaceProperties(properties.getProperty(key), replacements));
        }
    }

    private static String replaceProperties(String s, Properties replacements) {
        for (Map.Entry<Object, Object> entry : replacements.entrySet()) {
            String key = "${" + entry.getKey() + "}";
            while (s.contains(key)) {
                s = s.replace(key, String.valueOf(entry.getValue()));
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties overrideDockerPropertiesWithSettingsFromUserHome(Properties p, Properties systemProperties) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)p);
        File usersDockerPropertiesFile = new File(systemProperties.getProperty("user.home"), ".docker.io.properties");
        if (usersDockerPropertiesFile.isFile()) {
            try (FileInputStream in = new FileInputStream(usersDockerPropertiesFile);){
                overriddenProperties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return overriddenProperties;
    }

    private static Properties overrideDockerPropertiesWithEnv(Properties properties, Map<String, String> env) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)properties);
        if (env.containsKey(DOCKER_HOST_PROPERTY)) {
            overriddenProperties.setProperty(DOCKER_IO_URL_PROPERTY, env.get(DOCKER_HOST_PROPERTY).replace("tcp", DockerClientConfig.protocol(env)));
        }
        for (Map.Entry<String, String> envEntry : env.entrySet()) {
            String envKey = envEntry.getKey();
            if (!ENV_NAME_TO_IO_NAME.containsKey(envKey)) continue;
            overriddenProperties.setProperty(ENV_NAME_TO_IO_NAME.get(envKey), envEntry.getValue());
        }
        return overriddenProperties;
    }

    private static String protocol(Map<String, String> env) {
        return env.containsKey(DOCKER_CERT_PATH_PROPERTY) || "1".equals(env.get(DOCKER_VERIFY_TLS_PROPERTY)) ? "https" : "http";
    }

    private static Properties overrideDockerPropertiesWithSystemProperties(Properties p, Properties systemProperties) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)p);
        for (String key : new String[]{DOCKER_IO_URL_PROPERTY, DOCKER_IO_VERSION_PROPERTY, DOCKER_IO_USERNAME_PROPERTY, DOCKER_IO_PASSWORD_PROPERTY, DOCKER_IO_EMAIL_PROPERTY, DOCKER_IO_SERVER_ADDRESS_PROPERTY, DOCKER_IO_DOCKER_CERT_PATH_PROPERTY, DOCKER_IO_DOCKER_CFG_PATH_PROPERTY}) {
            if (!systemProperties.containsKey(key)) continue;
            overriddenProperties.setProperty(key, systemProperties.getProperty(key));
        }
        return overriddenProperties;
    }

    public static DockerClientConfigBuilder createDefaultConfigBuilder() {
        return DockerClientConfig.createDefaultConfigBuilder(System.getenv(), System.getProperties());
    }

    static DockerClientConfigBuilder createDefaultConfigBuilder(Map<String, String> env, Properties systemProperties) {
        Properties properties = DockerClientConfig.loadIncludedDockerProperties(systemProperties);
        properties = DockerClientConfig.overrideDockerPropertiesWithSettingsFromUserHome(properties, systemProperties);
        properties = DockerClientConfig.overrideDockerPropertiesWithEnv(properties, env);
        properties = DockerClientConfig.overrideDockerPropertiesWithSystemProperties(properties, systemProperties);
        return new DockerClientConfigBuilder().withProperties(properties);
    }

    public URI getUri() {
        return this.uri;
    }

    public RemoteApiVersion getVersion() {
        return this.version;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    public String getDockerCfgPath() {
        return this.dockerCfgPath;
    }

    private AuthConfig getAuthConfig() {
        AuthConfig authConfig = null;
        if (this.getUsername() != null && this.getPassword() != null && this.getEmail() != null && this.getServerAddress() != null) {
            authConfig = new AuthConfig();
            authConfig.setUsername(this.getUsername());
            authConfig.setPassword(this.getPassword());
            authConfig.setEmail(this.getEmail());
            authConfig.setServerAddress(this.getServerAddress());
        }
        return authConfig;
    }

    public AuthConfig effectiveAuthConfig(String imageName) {
        AuthConfig _authConfig;
        AuthConfig authConfig = null;
        String dockerCfgFile = this.getDockerCfgPath();
        if (dockerCfgFile != null && imageName != null) {
            AuthConfigFile authConfigFile;
            try {
                authConfigFile = AuthConfigFile.loadConfig(new File(dockerCfgFile));
            }
            catch (IOException e) {
                throw new DockerClientException("Failed to parse dockerCfgFile", e);
            }
            NameParser.ReposTag reposTag = NameParser.parseRepositoryTag(imageName);
            NameParser.HostnameReposName hostnameReposName = NameParser.resolveRepositoryName(reposTag.repos);
            authConfig = authConfigFile.resolveAuthConfig(hostnameReposName.hostname);
        }
        if ((_authConfig = this.getAuthConfig()) != null) {
            authConfig = _authConfig;
        }
        return authConfig;
    }

    public AuthConfigurations getAuthConfigurations() {
        String dockerCfgFile = this.getDockerCfgPath();
        if (dockerCfgFile != null) {
            AuthConfigFile authConfigFile;
            try {
                authConfigFile = AuthConfigFile.loadConfig(new File(dockerCfgFile));
            }
            catch (IOException e) {
                throw new DockerClientException("Failed to parse dockerCfgFile", e);
            }
            return authConfigFile.getAuthConfigurations();
        }
        return new AuthConfigurations();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerClientConfig that = (DockerClientConfig)o;
        if (this.sslConfig != null ? !this.sslConfig.equals(that.sslConfig) : that.sslConfig != null) {
            return false;
        }
        if (this.dockerCfgPath != null ? !this.dockerCfgPath.equals(that.dockerCfgPath) : that.dockerCfgPath != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.serverAddress != null ? !this.serverAddress.equals(that.serverAddress) : that.serverAddress != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.serverAddress != null ? this.serverAddress.hashCode() : 0);
        result = 31 * result + (this.dockerCfgPath != null ? this.dockerCfgPath.hashCode() : 0);
        result = 31 * result + (this.sslConfig != null ? this.sslConfig.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DockerClientConfig{uri=" + this.uri + ", version='" + this.version + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", email='" + this.email + '\'' + ", serverAddress='" + this.serverAddress + '\'' + ", dockerCfgPath='" + this.dockerCfgPath + '\'' + ", sslConfig='" + this.sslConfig + '\'' + '}';
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("DOCKER_URL", DOCKER_IO_URL_PROPERTY);
        m.put("DOCKER_VERSION", DOCKER_IO_VERSION_PROPERTY);
        m.put("DOCKER_USERNAME", DOCKER_IO_USERNAME_PROPERTY);
        m.put("DOCKER_PASSWORD", DOCKER_IO_PASSWORD_PROPERTY);
        m.put("DOCKER_EMAIL", DOCKER_IO_EMAIL_PROPERTY);
        m.put("DOCKER_SERVER_ADDRESS", DOCKER_IO_SERVER_ADDRESS_PROPERTY);
        m.put(DOCKER_CERT_PATH_PROPERTY, DOCKER_IO_DOCKER_CERT_PATH_PROPERTY);
        m.put("DOCKER_CFG_PATH", DOCKER_IO_DOCKER_CFG_PATH_PROPERTY);
        ENV_NAME_TO_IO_NAME = Collections.unmodifiableMap(m);
    }

    public static class DockerClientConfigBuilder {
        private URI uri;
        private String version;
        private String username;
        private String password;
        private String email;
        private String serverAddress;
        private String dockerCfgPath;
        private SSLConfig sslConfig;

        public DockerClientConfigBuilder withProperties(Properties p) {
            return this.withUri(p.getProperty(DockerClientConfig.DOCKER_IO_URL_PROPERTY)).withVersion(p.getProperty(DockerClientConfig.DOCKER_IO_VERSION_PROPERTY)).withUsername(p.getProperty(DockerClientConfig.DOCKER_IO_USERNAME_PROPERTY)).withPassword(p.getProperty(DockerClientConfig.DOCKER_IO_PASSWORD_PROPERTY)).withEmail(p.getProperty(DockerClientConfig.DOCKER_IO_EMAIL_PROPERTY)).withServerAddress(p.getProperty(DockerClientConfig.DOCKER_IO_SERVER_ADDRESS_PROPERTY)).withDockerCertPath(p.getProperty(DockerClientConfig.DOCKER_IO_DOCKER_CERT_PATH_PROPERTY)).withDockerCfgPath(p.getProperty(DockerClientConfig.DOCKER_IO_DOCKER_CFG_PATH_PROPERTY));
        }

        public final DockerClientConfigBuilder withUri(String uri) {
            Preconditions.checkNotNull((Object)uri, (Object)"uri was not specified");
            this.uri = URI.create(uri);
            return this;
        }

        public final DockerClientConfigBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public final DockerClientConfigBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public final DockerClientConfigBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public final DockerClientConfigBuilder withEmail(String email) {
            this.email = email;
            return this;
        }

        public DockerClientConfigBuilder withServerAddress(String serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        public final DockerClientConfigBuilder withDockerCertPath(String dockerCertPath) {
            if (dockerCertPath != null) {
                this.sslConfig = new LocalDirectorySSLConfig(dockerCertPath);
            }
            return this;
        }

        public final DockerClientConfigBuilder withDockerCfgPath(String dockerCfgPath) {
            this.dockerCfgPath = dockerCfgPath;
            return this;
        }

        public final DockerClientConfigBuilder withSSLConfig(SSLConfig config) {
            this.sslConfig = config;
            return this;
        }

        public DockerClientConfig build() {
            return new DockerClientConfig(this.uri, this.version, this.username, this.password, this.email, this.serverAddress, this.dockerCfgPath, this.sslConfig);
        }
    }
}

