/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Volume;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Bind {
    private String path;
    private Volume volume;
    private AccessMode accessMode;

    public Bind(String path, Volume volume) {
        this(path, volume, AccessMode.DEFAULT);
    }

    public Bind(String path, Volume volume, AccessMode accessMode) {
        this.path = path;
        this.volume = volume;
        this.accessMode = accessMode;
    }

    public String getPath() {
        return this.path;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public static Bind parse(String serialized) {
        try {
            String[] parts = serialized.split(":");
            switch (parts.length) {
                case 2: {
                    return new Bind(parts[0], new Volume(parts[1]));
                }
                case 3: {
                    AccessMode accessMode = AccessMode.valueOf(parts[2].toLowerCase());
                    return new Bind(parts[0], new Volume(parts[1]), accessMode);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing Bind '" + serialized + "'");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bind) {
            Bind other = (Bind)obj;
            return new EqualsBuilder().append((Object)this.path, (Object)other.getPath()).append((Object)this.volume, (Object)other.getVolume()).append((Object)this.accessMode, (Object)other.getAccessMode()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.path).append((Object)this.volume).append((Object)this.accessMode).toHashCode();
    }

    public String toString() {
        return this.path + ":" + this.volume.getPath() + ":" + this.accessMode.toString();
    }
}

