/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.codec.binary.Base64;

public abstract class AbstrDockerCmdExec {
    private final DockerClientConfig dockerClientConfig;
    private final WebTarget baseResource;

    public AbstrDockerCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull((Object)baseResource, (Object)"baseResource was not specified");
        Preconditions.checkNotNull((Object)dockerClientConfig, (Object)"dockerClientConfig was not specified");
        this.baseResource = baseResource;
        this.dockerClientConfig = dockerClientConfig;
    }

    protected WebTarget getBaseResource() {
        return this.baseResource;
    }

    protected AuthConfigurations getBuildAuthConfigs() {
        return this.dockerClientConfig.getAuthConfigurations();
    }

    protected String registryAuth(AuthConfig authConfig) {
        try {
            return Base64.encodeBase64String((byte[])new ObjectMapper().writeValueAsString((Object)authConfig).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String registryConfigs(AuthConfigurations authConfigs) {
        try {
            String json = this.dockerClientConfig.getApiVersion().isGreaterOrEqual(RemoteApiVersion.VERSION_1_19) ? new ObjectMapper().writeValueAsString(authConfigs.getConfigs()) : new ObjectMapper().writeValueAsString((Object)authConfigs);
            return Base64.encodeBase64String((byte[])json.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean bool(Boolean bool) {
        return bool != null && bool != false;
    }

    protected WebTarget booleanQueryParam(WebTarget webTarget, String name, Boolean value) {
        if (this.bool(value)) {
            webTarget = webTarget.queryParam(name, new Object[]{this.bool(value) + ""});
        }
        return webTarget;
    }
}

