/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.github.dockerjava.netty.ChannelProvider;
import com.github.dockerjava.netty.MediaType;
import com.github.dockerjava.netty.handler.FramedResponseStreamHandler;
import com.github.dockerjava.netty.handler.HttpConnectionHijackHandler;
import com.github.dockerjava.netty.handler.HttpRequestProvider;
import com.github.dockerjava.netty.handler.HttpResponseHandler;
import com.github.dockerjava.netty.handler.HttpResponseStreamHandler;
import com.github.dockerjava.netty.handler.JsonResponseCallbackHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.json.JsonObjectDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class InvocationBuilder {
    private ChannelProvider channelProvider;
    private String resource;
    private Map<String, String> headers = new HashMap<String, String>();

    public InvocationBuilder(ChannelProvider channelProvider, String resource) {
        this.channelProvider = channelProvider;
        this.resource = resource;
    }

    public InvocationBuilder accept(MediaType mediaType) {
        return this.header(HttpHeaderNames.ACCEPT.toString(), mediaType.getMediaType());
    }

    public InvocationBuilder header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public void delete() {
        HttpRequestProvider requestProvider = this.httpDeleteRequestProvider();
        ResponseCallback callback = new ResponseCallback();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, callback);
        Channel channel = this.getChannel();
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        this.sendRequest(requestProvider, channel);
        callback.awaitResult();
    }

    public void get(ResultCallback<Frame> resultCallback) {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        FramedResponseStreamHandler streamHandler = new FramedResponseStreamHandler(resultCallback);
        Channel channel = this.getChannel();
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{streamHandler});
        this.sendRequest(requestProvider, channel);
    }

    public <T> T get(TypeReference<T> typeReference) {
        ResponseCallback callback = new ResponseCallback();
        this.get(typeReference, callback);
        return callback.awaitResult();
    }

    public <T> void get(TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        Channel channel = this.getChannel();
        JsonResponseCallbackHandler<T> jsonResponseHandler = new JsonResponseCallbackHandler<T>(typeReference, resultCallback);
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{new JsonObjectDecoder()});
        channel.pipeline().addLast(new ChannelHandler[]{jsonResponseHandler});
        this.sendRequest(requestProvider, channel);
    }

    private Channel getChannel() {
        return this.channelProvider.getChannel();
    }

    private HttpRequestProvider httpDeleteRequestProvider() {
        return new HttpRequestProvider(){

            @Override
            public HttpRequest getHttpRequest(String uri) {
                return InvocationBuilder.this.prepareDeleteRequest(uri);
            }
        };
    }

    private HttpRequestProvider httpGetRequestProvider() {
        return new HttpRequestProvider(){

            @Override
            public HttpRequest getHttpRequest(String uri) {
                return InvocationBuilder.this.prepareGetRequest(uri);
            }
        };
    }

    private HttpRequestProvider httpPostRequestProvider(final Object entity) {
        return new HttpRequestProvider(){

            @Override
            public HttpRequest getHttpRequest(String uri) {
                return InvocationBuilder.this.preparePostRequest(uri, entity);
            }
        };
    }

    private HttpRequestProvider httpPutRequestProvider(final Object entity) {
        return new HttpRequestProvider(){

            @Override
            public HttpRequest getHttpRequest(String uri) {
                return InvocationBuilder.this.preparePutRequest(uri, entity);
            }
        };
    }

    public InputStream post(Object entity) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        Channel channel = this.getChannel();
        ResponseCallback<InputStream> callback = new ResponseCallback<InputStream>();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, callback);
        HttpResponseStreamHandler streamHandler = new HttpResponseStreamHandler(callback);
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{streamHandler});
        this.sendRequest(requestProvider, channel);
        return callback.awaitResult();
    }

    public void post(Object entity, final InputStream stdin, final ResultCallback<Frame> resultCallback) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        FramedResponseStreamHandler streamHandler = new FramedResponseStreamHandler(resultCallback);
        final Channel channel = this.getChannel();
        channel.closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                resultCallback.onComplete();
            }
        });
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        HttpConnectionHijackHandler hijackHandler = new HttpConnectionHijackHandler(responseHandler);
        HttpClientCodec httpClientCodec = (HttpClientCodec)channel.pipeline().get(HttpClientCodec.class);
        channel.pipeline().addLast(new ChannelHandler[]{new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)httpClientCodec, (HttpClientUpgradeHandler.UpgradeCodec)hijackHandler, Integer.MAX_VALUE)});
        channel.pipeline().addLast(new ChannelHandler[]{streamHandler});
        this.sendRequest(requestProvider, channel);
        hijackHandler.awaitUpgrade();
        if (stdin != null) {
            new Thread(new Runnable(){

                private int read(BufferedReader reader) {
                    try {
                        return reader.read();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void run() {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stdin, Charset.forName("UTF-8")));
                    int read = -1;
                    while ((read = this.read(reader)) != -1) {
                        byte[] bytes = ByteBuffer.allocate(4).putInt(read).array();
                        try {
                            bytes = new String(bytes).getBytes("US-ASCII");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                        channel.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])bytes));
                    }
                }
            }).start();
        }
    }

    public <T> T post(Object entity, TypeReference<T> typeReference) {
        ResponseCallback callback = new ResponseCallback();
        this.post(entity, typeReference, callback);
        return callback.awaitResult();
    }

    public <T> void post(Object entity, TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        Channel channel = this.getChannel();
        JsonResponseCallbackHandler<T> jsonResponseHandler = new JsonResponseCallbackHandler<T>(typeReference, resultCallback);
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{new JsonObjectDecoder()});
        channel.pipeline().addLast(new ChannelHandler[]{jsonResponseHandler});
        this.sendRequest(requestProvider, channel);
    }

    private HttpRequest prepareDeleteRequest(String uri) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.DELETE, uri);
        this.setDefaultHeaders((HttpRequest)request);
        return request;
    }

    private FullHttpRequest prepareGetRequest(String uri) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri);
        this.setDefaultHeaders((HttpRequest)request);
        return request;
    }

    private HttpRequest preparePostRequest(String uri, Object entity) {
        return this.prepareEntityRequest(uri, entity, HttpMethod.POST);
    }

    private HttpRequest preparePutRequest(String uri, Object entity) {
        return this.prepareEntityRequest(uri, entity, HttpMethod.PUT);
    }

    private HttpRequest prepareEntityRequest(String uri, Object entity, HttpMethod httpMethod) {
        DefaultHttpRequest request = null;
        if (entity != null) {
            byte[] bytes;
            DefaultFullHttpRequest fullRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uri);
            try {
                bytes = new ObjectMapper().writeValueAsBytes(entity);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            fullRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
            fullRequest.content().clear().writeBytes(Unpooled.copiedBuffer((byte[])bytes));
            fullRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
            request = fullRequest;
        } else {
            request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uri);
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        }
        this.setDefaultHeaders((HttpRequest)request);
        return request;
    }

    private void sendRequest(HttpRequestProvider requestProvider, Channel channel) {
        ChannelFuture channelFuture = channel.writeAndFlush((Object)requestProvider.getHttpRequest(this.resource));
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
            }
        });
    }

    private void setDefaultHeaders(HttpRequest request) {
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"");
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            request.headers().set((CharSequence)entry.getKey(), (Object)entry.getValue());
        }
    }

    public <T> T post(TypeReference<T> typeReference, InputStream body) {
        ResponseCallback callback = new ResponseCallback();
        this.post(typeReference, callback, body);
        return callback.awaitResult();
    }

    public <T> void post(TypeReference<T> typeReference, ResultCallback<T> resultCallback, InputStream body) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(null);
        Channel channel = this.getChannel();
        JsonResponseCallbackHandler<T> jsonResponseHandler = new JsonResponseCallbackHandler<T>(typeReference, resultCallback);
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{new JsonObjectDecoder()});
        channel.pipeline().addLast(new ChannelHandler[]{jsonResponseHandler});
        HttpRequest request = requestProvider.getHttpRequest(this.resource);
        if (request instanceof FullHttpRequest) {
            throw new DockerClientException("fatal: request is instance of FullHttpRequest");
        }
        request.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        request.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        channel.write((Object)request);
        channel.write((Object)new ChunkedStream((InputStream)new BufferedInputStream(body, 0x100000), 0x100000));
        channel.write((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        channel.flush();
    }

    public InputStream get() {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        Channel channel = this.getChannel();
        ResponseCallback<InputStream> resultCallback = new ResponseCallback<InputStream>();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        HttpResponseStreamHandler streamHandler = new HttpResponseStreamHandler(resultCallback);
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{streamHandler});
        this.sendRequest(requestProvider, channel);
        return resultCallback.awaitResult();
    }

    public void put(InputStream body, MediaType mediaType) {
        HttpRequestProvider requestProvider = this.httpPutRequestProvider(null);
        Channel channel = this.getChannel();
        ResponseCallback resultCallback = new ResponseCallback();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        HttpRequest request = requestProvider.getHttpRequest(this.resource);
        if (request instanceof FullHttpRequest) {
            throw new DockerClientException("fatal: request is instance of FullHttpRequest");
        }
        request.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        request.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType.getMediaType());
        channel.write((Object)request);
        channel.write((Object)new ChunkedStream((InputStream)new BufferedInputStream(body, 0x100000)));
        channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        resultCallback.awaitResult();
    }

    public class ResponseCallback<T>
    extends ResultCallbackTemplate<ResponseCallback<T>, T> {
        private T result = null;

        public T awaitResult() {
            try {
                this.awaitCompletion();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.result;
        }

        @Override
        public void onNext(T object) {
            this.result = object;
        }
    }
}

