/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.dockerfile;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.core.GoLangFileMatch;
import com.github.dockerjava.core.dockerfile.DockerfileStatement;
import com.github.dockerjava.core.exception.GoLangFileMatchException;
import com.github.dockerjava.core.util.CompressArchiveUtil;
import com.github.dockerjava.core.util.FilePathUtil;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class Dockerfile {
    public final File dockerFile;

    public Dockerfile(File dockerFile) {
        if (!dockerFile.exists()) {
            throw new IllegalStateException(String.format("Dockerfile %s does not exist", dockerFile.getAbsolutePath()));
        }
        if (!dockerFile.isFile()) {
            throw new IllegalStateException(String.format("Dockerfile %s is not a file", dockerFile.getAbsolutePath()));
        }
        this.dockerFile = dockerFile;
    }

    public Iterable<DockerfileStatement> getStatements() throws IOException {
        List dockerFileContent = FileUtils.readLines((File)this.dockerFile);
        if (dockerFileContent.size() <= 0) {
            throw new DockerClientException(String.format("Dockerfile %s is empty", this.dockerFile));
        }
        Collection optionals = Collections2.transform((Collection)dockerFileContent, (Function)new LineTransformer());
        return Optional.presentInstances((Iterable)optionals);
    }

    public List<String> getIgnores() throws IOException {
        ArrayList<String> ignores = new ArrayList<String>();
        File dockerIgnoreFile = new File(this.getDockerFolder(), ".dockerignore");
        if (dockerIgnoreFile.exists()) {
            int lineNumber = 0;
            List dockerIgnoreFileContent = FileUtils.readLines((File)dockerIgnoreFile);
            for (String pattern : dockerIgnoreFileContent) {
                ++lineNumber;
                if ((pattern = pattern.trim()).isEmpty()) continue;
                pattern = FilenameUtils.normalize((String)pattern);
                try {
                    ignores.add(pattern);
                }
                catch (GoLangFileMatchException e) {
                    throw new DockerClientException(String.format("Invalid pattern '%s' on line %s in .dockerignore file", pattern, lineNumber));
                }
            }
        }
        return ignores;
    }

    public ScannedResult parse() throws IOException {
        return new ScannedResult();
    }

    public File getDockerFolder() {
        return this.dockerFile.getParentFile();
    }

    public class ScannedResult {
        final List<String> ignores;
        final List<File> filesToAdd = new ArrayList<File>();

        public InputStream buildDockerFolderTar() {
            return this.buildDockerFolderTar(Dockerfile.this.getDockerFolder());
        }

        public InputStream buildDockerFolderTar(File directory) {
            File dockerFolderTar = null;
            try {
                String archiveNameWithOutExtension = UUID.randomUUID().toString();
                dockerFolderTar = CompressArchiveUtil.archiveTARFiles(directory, this.filesToAdd, archiveNameWithOutExtension);
                long length = dockerFolderTar.length();
                final FileInputStream tarInputStream = FileUtils.openInputStream((File)dockerFolderTar);
                final File tarFile = dockerFolderTar;
                return new InputStream(){

                    @Override
                    public int available() throws IOException {
                        return tarInputStream.available();
                    }

                    @Override
                    public int read() throws IOException {
                        return tarInputStream.read();
                    }

                    @Override
                    public int read(byte[] buff, int offset, int len) throws IOException {
                        return tarInputStream.read(buff, offset, len);
                    }

                    @Override
                    public void close() throws IOException {
                        IOUtils.closeQuietly((InputStream)tarInputStream);
                        FileUtils.deleteQuietly((File)tarFile);
                    }
                };
            }
            catch (IOException ex) {
                FileUtils.deleteQuietly(dockerFolderTar);
                throw new DockerClientException("Error occurred while preparing Docker context folder.", ex);
            }
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("ignores", this.ignores).add("filesToAdd", this.filesToAdd).toString();
        }

        public ScannedResult() throws IOException {
            this.ignores = Dockerfile.this.getIgnores();
            String matchingIgnorePattern = this.effectiveMatchingIgnorePattern(Dockerfile.this.dockerFile);
            if (matchingIgnorePattern != null) {
                throw new DockerClientException(String.format("Dockerfile is excluded by pattern '%s' in .dockerignore file", matchingIgnorePattern));
            }
            Collection filesInBuildContext = FileUtils.listFiles((File)Dockerfile.this.getDockerFolder(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File f : filesInBuildContext) {
                if (this.effectiveMatchingIgnorePattern(f) != null) continue;
                this.filesToAdd.add(f);
            }
        }

        private List<String> matchingIgnorePatterns(String fileName) {
            ArrayList<String> matches = new ArrayList<String>();
            int lineNumber = 0;
            for (String pattern : this.ignores) {
                ++lineNumber;
                try {
                    if (!GoLangFileMatch.match(pattern, fileName)) continue;
                    matches.add(pattern);
                }
                catch (GoLangFileMatchException e) {
                    throw new DockerClientException(String.format("Invalid pattern '%s' on line %s in .dockerignore file", pattern, lineNumber));
                }
            }
            return matches;
        }

        private String effectiveMatchingIgnorePattern(File file) {
            String relativeFilename = FilePathUtil.relativize(Dockerfile.this.getDockerFolder(), file);
            List<String> matchingPattern = this.matchingIgnorePatterns(relativeFilename);
            if (matchingPattern.isEmpty()) {
                return null;
            }
            String lastMatchingPattern = matchingPattern.get(matchingPattern.size() - 1);
            int lastMatchingPatternIndex = this.ignores.lastIndexOf(lastMatchingPattern);
            if (lastMatchingPatternIndex == this.ignores.size() - 1) {
                return lastMatchingPattern;
            }
            List<String> remainingIgnorePattern = this.ignores.subList(lastMatchingPatternIndex + 1, this.ignores.size());
            for (String ignorePattern : remainingIgnorePattern) {
                if (!ignorePattern.equals("!" + relativeFilename)) continue;
                return null;
            }
            return lastMatchingPattern;
        }
    }

    private static class LineTransformer
    implements Function<String, Optional<? extends DockerfileStatement>> {
        private int line = 0;

        private LineTransformer() {
        }

        public Optional<? extends DockerfileStatement> apply(String input) {
            try {
                ++this.line;
                return DockerfileStatement.createFromLine(input);
            }
            catch (Exception ex) {
                throw new DockerClientException("Error on dockerfile line " + this.line);
            }
        }
    }
}

