/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.core.exception.GoLangFileMatchException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GoLangFileMatch {
    public static final boolean IS_WINDOWS = File.separatorChar == '\\';

    private GoLangFileMatch() {
    }

    public static boolean match(List<String> patterns, File file) {
        return !GoLangFileMatch.match(patterns, file.getPath()).isEmpty();
    }

    public static boolean match(String pattern, File file) {
        return GoLangFileMatch.match(pattern, file.getPath());
    }

    public static List<String> match(List<String> patterns, String name) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String pattern : patterns) {
            if (!GoLangFileMatch.match(pattern, name)) continue;
            matches.add(pattern);
        }
        return matches;
    }

    public static boolean match(String pattern, String name) {
        block0: while (!pattern.isEmpty()) {
            ScanResult scanResult = GoLangFileMatch.scanChunk(pattern);
            pattern = scanResult.pattern;
            if (scanResult.star && StringUtils.isEmpty((String)scanResult.chunk)) {
                return name.indexOf(File.separatorChar) < 0;
            }
            String matchResult = GoLangFileMatch.matchChunk(scanResult.chunk, name);
            if (matchResult != null && (matchResult.isEmpty() || !pattern.isEmpty())) {
                name = matchResult;
                continue;
            }
            if (scanResult.star) {
                for (int i = 0; i < name.length() && name.charAt(i) != File.separatorChar; ++i) {
                    matchResult = GoLangFileMatch.matchChunk(scanResult.chunk, name.substring(i + 1));
                    if (matchResult == null || pattern.isEmpty() && !matchResult.isEmpty()) continue;
                    name = matchResult;
                    continue block0;
                }
            }
            return false;
        }
        return name.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    static ScanResult scanChunk(String pattern) {
        boolean star = false;
        if (!pattern.isEmpty() && pattern.charAt(0) == '*') {
            pattern = pattern.substring(1);
            star = true;
        }
        boolean inRange = false;
        int i = 0;
        while (i < pattern.length()) {
            switch (pattern.charAt(i)) {
                case '\\': {
                    if (IS_WINDOWS || i + 1 >= pattern.length()) break;
                    ++i;
                    break;
                }
                case '[': {
                    inRange = true;
                    break;
                }
                case ']': {
                    inRange = false;
                    break;
                }
                case '*': {
                    if (inRange) break;
                    return new ScanResult(star, pattern.substring(0, i), pattern.substring(i));
                }
            }
            ++i;
        }
        return new ScanResult(star, pattern.substring(0, i), pattern.substring(i));
    }

    static String matchChunk(String chunk, String s) {
        int chunkLength = chunk.length();
        int chunkOffset = 0;
        int sLength = s.length();
        int sOffset = 0;
        block5: while (chunkOffset < chunkLength) {
            if (sOffset == sLength) {
                return null;
            }
            switch (chunk.charAt(chunkOffset)) {
                case '[': {
                    boolean negated;
                    char r = s.charAt(sOffset);
                    ++sOffset;
                    if (++chunkOffset == chunkLength) {
                        throw new GoLangFileMatchException();
                    }
                    boolean bl = negated = chunk.charAt(chunkOffset) == '^';
                    if (negated) {
                        ++chunkOffset;
                    }
                    boolean match = false;
                    int nrange = 0;
                    while (true) {
                        char lo;
                        if (chunkOffset < chunkLength && chunk.charAt(chunkOffset) == ']' && nrange > 0) {
                            ++chunkOffset;
                            break;
                        }
                        GetEscResult result = GoLangFileMatch.getEsc(chunk, chunkOffset, chunkLength);
                        char hi = lo = result.lo;
                        chunkOffset = result.chunkOffset;
                        if (chunk.charAt(chunkOffset) == '-') {
                            result = GoLangFileMatch.getEsc(chunk, ++chunkOffset, chunkLength);
                            chunkOffset = result.chunkOffset;
                            hi = result.lo;
                        }
                        if (lo <= r && r <= hi) {
                            match = true;
                        }
                        ++nrange;
                    }
                    if (match != negated) continue block5;
                    return null;
                }
                case '?': {
                    if (s.charAt(sOffset) == File.separatorChar) {
                        return null;
                    }
                    ++sOffset;
                    ++chunkOffset;
                    continue block5;
                }
                case '\\': {
                    if (IS_WINDOWS || ++chunkOffset != chunkLength) break;
                    throw new GoLangFileMatchException();
                }
            }
            if (chunk.charAt(chunkOffset) != s.charAt(sOffset)) {
                return null;
            }
            ++sOffset;
            ++chunkOffset;
        }
        return s.substring(sOffset);
    }

    static GetEscResult getEsc(String chunk, int chunkOffset, int chunkLength) {
        if (chunkOffset == chunkLength) {
            throw new GoLangFileMatchException();
        }
        char r = chunk.charAt(chunkOffset);
        if (r == '-' || r == ']') {
            throw new GoLangFileMatchException();
        }
        if (r == '\\' && !IS_WINDOWS && ++chunkOffset == chunkLength) {
            throw new GoLangFileMatchException();
        }
        r = chunk.charAt(chunkOffset);
        if (++chunkOffset == chunkLength) {
            throw new GoLangFileMatchException();
        }
        return new GetEscResult(r, chunkOffset);
    }

    private static final class GetEscResult {
        public char lo;
        public int chunkOffset;

        GetEscResult(char lo, int chunkOffset) {
            this.lo = lo;
            this.chunkOffset = chunkOffset;
        }
    }

    private static final class ScanResult {
        public boolean star;
        public String chunk;
        public String pattern;

        ScanResult(boolean star, String chunk, String pattern) {
            this.star = star;
            this.chunk = chunk;
            this.pattern = pattern;
        }
    }
}

