/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="npm", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public final class NpmMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", property="workingDirectory", required=false)
    private File workingDirectory;
    @Parameter(defaultValue="install", property="frontend.npm.arguments", required=false)
    private String arguments;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildContext buildContext;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;
    @Parameter(property="skip.npm", defaultValue="false")
    private Boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip.booleanValue()) {
            File packageJson = new File(this.workingDirectory, "package.json");
            if (this.buildContext == null || this.buildContext.hasDelta(packageJson) || !this.buildContext.isIncremental()) {
                try {
                    ProxyConfig proxyConfig = MojoUtils.getProxyConfig(this.session, this.decrypter);
                    new FrontendPluginFactory(this.workingDirectory, proxyConfig).getNpmRunner().execute(this.arguments);
                }
                catch (TaskRunnerException e) {
                    throw new MojoFailureException("Failed to run task", (Throwable)e);
                }
            } else {
                this.getLog().info((CharSequence)"Skipping npm install as package.json unchanged");
            }
        }
    }
}

