/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import java.io.File;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

class MojoUtils {
    MojoUtils() {
    }

    static <E extends Throwable> MojoFailureException toMojoFailureException(E e) {
        return new MojoFailureException(e.getMessage() + ": " + e.getCause().getMessage(), e);
    }

    static ProxyConfig getProxyConfig(MavenSession mavenSession, SettingsDecrypter decrypter) {
        if (mavenSession == null || mavenSession.getSettings() == null || mavenSession.getSettings().getActiveProxy() == null || !mavenSession.getSettings().getActiveProxy().isActive()) {
            return null;
        }
        Proxy mavenProxy = mavenSession.getSettings().getActiveProxy();
        DefaultSettingsDecryptionRequest decryptionRequest = new DefaultSettingsDecryptionRequest(mavenProxy);
        SettingsDecryptionResult decryptedResult = decrypter.decrypt((SettingsDecryptionRequest)decryptionRequest);
        mavenProxy = decryptedResult.getProxy();
        return new ProxyConfig(mavenProxy.getId(), mavenProxy.getProtocol(), mavenProxy.getHost(), mavenProxy.getPort(), mavenProxy.getUsername(), mavenProxy.getPassword());
    }

    static boolean shouldExecute(BuildContext buildContext, List<File> triggerfiles, File srcdir) {
        if (buildContext == null || !buildContext.isIncremental()) {
            return true;
        }
        if (triggerfiles != null) {
            for (File triggerfile : triggerfiles) {
                if (!buildContext.hasDelta(triggerfile)) continue;
                return true;
            }
        }
        if (srcdir == null) {
            return true;
        }
        Scanner scanner = buildContext.newScanner(srcdir);
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        return includedFiles != null && includedFiles.length > 0;
    }
}

