/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.NodeAndNPMInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultNodeAndNPMInstaller
implements NodeAndNPMInstaller {
    private static final String DEFAULT_DOWNLOAD_ROOT = "http://nodejs.org/dist/";
    private final File workingDirectory;
    private final Logger logger;
    private final Platform platform;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;

    DefaultNodeAndNPMInstaller(File workingDirectory, Platform platform, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.workingDirectory = workingDirectory;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.platform = platform;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
    }

    @Override
    public void install(String nodeVersion, String npmVersion) throws InstallationException {
        new NodeAndNPMInstallAction(nodeVersion, npmVersion, null).install();
    }

    @Override
    public void install(String nodeVersion, String npmVersion, String downloadRoot) throws InstallationException {
        if (downloadRoot == null || downloadRoot.isEmpty()) {
            downloadRoot = DEFAULT_DOWNLOAD_ROOT;
        }
        new NodeAndNPMInstallAction(nodeVersion, npmVersion, downloadRoot).install();
    }

    private boolean hasShortcutScripts() {
        return new File(this.workingDirectory + Utils.normalize("/node/with_new_path.sh")).exists();
    }

    private void createShortcutScripts() throws InstallationException {
        try {
            File script = new File(this.workingDirectory + Utils.normalize("/node/with_new_path.sh"));
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(script)));
            pw.println("#!/bin/sh");
            if (this.platform.isMac()) {
                pw.println("export PATH=\"$(dirname $(python -c 'import os,sys;print os.path.realpath(sys.argv[1])' $0)):$PATH\"");
            } else {
                pw.println("export PATH=\"$(dirname $(readlink -f $0)):$PATH\"");
            }
            pw.println("\"$@\"");
            pw.close();
            this.logger.info("Created npm script " + script);
        }
        catch (IOException e) {
            throw new InstallationException("Could not create path script", e);
        }
    }

    private final class NodeAndNPMInstallAction {
        private static final String VERSION = "version";
        private final String nodeVersion;
        private final String npmVersion;
        private final String downloadRoot;

        public NodeAndNPMInstallAction(String nodeVersion, String npmVersion, String downloadRoot) {
            this.nodeVersion = nodeVersion;
            this.npmVersion = npmVersion;
            this.downloadRoot = downloadRoot;
        }

        public void install() throws InstallationException {
            if (!this.nodeIsAlreadyInstalled()) {
                if (DefaultNodeAndNPMInstaller.this.platform.isWindows()) {
                    this.installNodeForWindows();
                } else {
                    this.installNodeDefault();
                }
            }
            if (!this.npmIsAlreadyInstalled()) {
                this.installNpm();
            }
            if (!DefaultNodeAndNPMInstaller.this.platform.isWindows() && !DefaultNodeAndNPMInstaller.this.hasShortcutScripts()) {
                DefaultNodeAndNPMInstaller.this.createShortcutScripts();
            }
        }

        private boolean nodeIsAlreadyInstalled() {
            if (DefaultNodeAndNPMInstaller.this.platform.isWindows()) {
                return this.nodeIsAlreadyInstalledOnWindows();
            }
            return this.nodeIsAlreadyInstalledDefault();
        }

        private boolean nodeIsAlreadyInstalledOnWindows() {
            return this.nodeIsAlreadyInstalled("\\node\\node.exe");
        }

        private boolean nodeIsAlreadyInstalledDefault() {
            return this.nodeIsAlreadyInstalled("/node/node");
        }

        private boolean nodeIsAlreadyInstalled(String nodeExeutable) {
            try {
                File nodeFile = new File(DefaultNodeAndNPMInstaller.this.workingDirectory + nodeExeutable);
                if (nodeFile.exists()) {
                    String version = new NodeExecutor(DefaultNodeAndNPMInstaller.this.workingDirectory, Arrays.asList("--version"), DefaultNodeAndNPMInstaller.this.platform).executeAndGetResult();
                    if (version.equals(this.nodeVersion)) {
                        DefaultNodeAndNPMInstaller.this.logger.info("Node " + version + " is already installed.");
                        return true;
                    }
                    DefaultNodeAndNPMInstaller.this.logger.info("Node " + version + " was installed, but we need version " + this.nodeVersion);
                    return false;
                }
                return false;
            }
            catch (ProcessExecutionException e) {
                return false;
            }
        }

        private boolean npmIsAlreadyInstalled() {
            try {
                File npmPackageJson = new File(DefaultNodeAndNPMInstaller.this.workingDirectory + Utils.normalize("/node/npm/package.json"));
                if (npmPackageJson.exists()) {
                    HashMap data = (HashMap)new ObjectMapper().readValue(npmPackageJson, HashMap.class);
                    if (data.containsKey(VERSION)) {
                        String foundNpmVersion = data.get(VERSION).toString();
                        DefaultNodeAndNPMInstaller.this.logger.info("Found NPM version " + foundNpmVersion);
                        if (foundNpmVersion.equals(this.npmVersion)) {
                            return true;
                        }
                        DefaultNodeAndNPMInstaller.this.logger.info("Mismatch between found NPM version and required NPM version");
                        return false;
                    }
                    DefaultNodeAndNPMInstaller.this.logger.info("Could not read NPM version from package.json");
                    return false;
                }
                return false;
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not read package.json", ex);
            }
        }

        private void installNpm() throws InstallationException {
            try {
                DefaultNodeAndNPMInstaller.this.logger.info("Installing npm version " + this.npmVersion);
                String downloadUrl = this.downloadRoot + "npm/npm-" + this.npmVersion + ".tgz";
                String targetName = DefaultNodeAndNPMInstaller.this.workingDirectory + File.separator + "npm.tar.gz";
                this.downloadFile(downloadUrl, targetName);
                this.extractFile(targetName, DefaultNodeAndNPMInstaller.this.workingDirectory + "/node");
                new File(targetName).delete();
                DefaultNodeAndNPMInstaller.this.logger.info("Installed NPM locally.");
            }
            catch (DownloadException e) {
                throw new InstallationException("Could not download npm", e);
            }
            catch (ArchiveExtractionException e) {
                throw new InstallationException("Could not extract the npm archive", e);
            }
        }

        private void installNodeDefault() throws InstallationException {
            String downloadUrl = "";
            try {
                DefaultNodeAndNPMInstaller.this.logger.info("Installing node version " + this.nodeVersion);
                if (!this.nodeVersion.startsWith("v")) {
                    DefaultNodeAndNPMInstaller.this.logger.warn("Node version does not start with naming convention 'v'.");
                }
                String longNodeFilename = DefaultNodeAndNPMInstaller.this.platform.getLongNodeFilename(this.nodeVersion);
                downloadUrl = this.downloadRoot + DefaultNodeAndNPMInstaller.this.platform.getNodeDownloadFilename(this.nodeVersion);
                File tmpDirectory = new File(DefaultNodeAndNPMInstaller.this.workingDirectory + File.separator + "node_tmp");
                DefaultNodeAndNPMInstaller.this.logger.info("Creating temporary directory " + tmpDirectory);
                tmpDirectory.mkdirs();
                String targetName = DefaultNodeAndNPMInstaller.this.workingDirectory + "/node_tmp/node.tar.gz";
                DefaultNodeAndNPMInstaller.this.logger.info("Downloading Node.js from " + downloadUrl + " to " + targetName);
                this.downloadFile(downloadUrl, targetName);
                DefaultNodeAndNPMInstaller.this.logger.info("Extracting Node.js files in node_tmp");
                this.extractFile(targetName, DefaultNodeAndNPMInstaller.this.workingDirectory + "/node_tmp");
                File nodeBinary = new File(DefaultNodeAndNPMInstaller.this.workingDirectory + "/node_tmp/" + longNodeFilename + "/bin/node");
                if (!nodeBinary.exists()) {
                    throw new FileNotFoundException("Could not find the downloaded Node.js binary in " + nodeBinary);
                }
                File destinationDirectory = new File(DefaultNodeAndNPMInstaller.this.workingDirectory + "/node");
                destinationDirectory.mkdirs();
                File destination = new File(DefaultNodeAndNPMInstaller.this.workingDirectory + "/node/node");
                DefaultNodeAndNPMInstaller.this.logger.info("Moving node binary to " + destination);
                if (!nodeBinary.renameTo(destination)) {
                    throw new InstallationException("Could not install Node: Was not allowed to rename " + nodeBinary + " to " + destination);
                }
                if (!destination.setExecutable(true, false)) {
                    throw new InstallationException("Cound not install Node: Was not allowed to make " + destination + " executable.");
                }
                DefaultNodeAndNPMInstaller.this.logger.info("Deleting temporary directory " + tmpDirectory);
                FileUtils.deleteDirectory((File)tmpDirectory);
                DefaultNodeAndNPMInstaller.this.logger.info("Installed node locally.");
            }
            catch (IOException e) {
                throw new InstallationException("Could not install Node", e);
            }
            catch (DownloadException e) {
                throw new InstallationException("Could not download Node.js", e);
            }
            catch (ArchiveExtractionException e) {
                throw new InstallationException("Could not extract the Node archive", e);
            }
        }

        private void installNodeForWindows() throws InstallationException {
            String downloadUrl = this.downloadRoot + DefaultNodeAndNPMInstaller.this.platform.getNodeDownloadFilename(this.nodeVersion);
            try {
                DefaultNodeAndNPMInstaller.this.logger.info("Installing node version " + this.nodeVersion);
                new File(DefaultNodeAndNPMInstaller.this.workingDirectory + "\\node").mkdirs();
                this.downloadFile(downloadUrl, DefaultNodeAndNPMInstaller.this.workingDirectory + "\\node\\node.exe");
                DefaultNodeAndNPMInstaller.this.logger.info("Installed node.exe locally.");
            }
            catch (DownloadException e) {
                throw new InstallationException("Could not download Node.js from: " + downloadUrl, e);
            }
        }

        private void extractFile(String archive, String destinationDirectory) throws ArchiveExtractionException {
            DefaultNodeAndNPMInstaller.this.logger.info("Unpacking " + archive + " into " + destinationDirectory);
            DefaultNodeAndNPMInstaller.this.archiveExtractor.extract(archive, destinationDirectory);
        }

        private void downloadFile(String downloadUrl, String destination) throws DownloadException {
            DefaultNodeAndNPMInstaller.this.fileDownloader.download(downloadUrl, destination);
        }
    }
}

