/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NodeTaskExecutor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String taskName;
    private final String taskLocation;
    private final Platform platform;
    private final File workingDirectory;
    private final List<String> additionalArguments;

    public NodeTaskExecutor(String taskName, String taskLocation, File workingDirectory, Platform platform, List<String> additionalArguments) {
        this.taskName = taskName;
        this.taskLocation = taskLocation;
        this.platform = platform;
        this.workingDirectory = workingDirectory;
        this.additionalArguments = additionalArguments;
    }

    public final void execute(String args) throws TaskRunnerException {
        String absoluteTaskLocation = this.workingDirectory + Utils.normalize(this.taskLocation);
        List<String> arguments = this.getArguments(args);
        this.logger.info("Running " + NodeTaskExecutor.taskToString(this.taskName, arguments) + " in " + this.workingDirectory);
        try {
            int result = new NodeExecutor(this.workingDirectory, Utils.prepend(absoluteTaskLocation, arguments), this.platform).executeAndRedirectOutput(this.logger);
            if (result != 0) {
                throw new TaskRunnerException(NodeTaskExecutor.taskToString(this.taskName, arguments) + " failed. (error code " + result + ")");
            }
        }
        catch (ProcessExecutionException e) {
            throw new TaskRunnerException(NodeTaskExecutor.taskToString(this.taskName, arguments) + " failed.");
        }
    }

    private List<String> getArguments(String args) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (args != null && !args.equals("null") && !args.isEmpty()) {
            arguments.addAll(Arrays.asList(args.split("\\s+")));
        }
        for (String argument : this.additionalArguments) {
            if (arguments.contains(argument)) continue;
            arguments.add(argument);
        }
        return arguments;
    }

    private static String taskToString(String taskName, List<String> commands) {
        return "'" + taskName + " " + Utils.implode(" ", commands) + "'";
    }
}

