/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.InputStreamHandler;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

final class ProcessExecutor {
    private final File workingDirectory;
    private final List<String> command;
    private final ProcessBuilder processBuilder;
    private final Platform platform;

    public ProcessExecutor(File workingDirectory, List<String> command, Platform platform) {
        this.workingDirectory = workingDirectory;
        this.command = command;
        this.platform = platform;
        this.processBuilder = this.createProcessBuilder();
    }

    public String executeAndGetResult() throws ProcessExecutionException {
        try {
            Process process = this.processBuilder.start();
            String result = ProcessExecutor.readString(process.getInputStream());
            String error = ProcessExecutor.readString(process.getErrorStream());
            int exitValue = process.waitFor();
            if (exitValue == 0) {
                return result;
            }
            throw new ProcessExecutionException(result + " " + error);
        }
        catch (IOException e) {
            throw new ProcessExecutionException(e);
        }
        catch (InterruptedException e) {
            throw new ProcessExecutionException(e);
        }
    }

    public int executeAndRedirectOutput(Logger logger) throws ProcessExecutionException {
        try {
            Process process = this.processBuilder.start();
            InputStreamHandler infoLogThread = InputStreamHandler.logInfo(process.getInputStream(), logger);
            infoLogThread.start();
            InputStreamHandler errorLogThread = InputStreamHandler.logError(process.getErrorStream(), logger);
            errorLogThread.start();
            int result = process.waitFor();
            infoLogThread.join();
            errorLogThread.join();
            return result;
        }
        catch (IOException e) {
            throw new ProcessExecutionException(e);
        }
        catch (InterruptedException e) {
            throw new ProcessExecutionException(e);
        }
    }

    private ProcessBuilder createProcessBuilder() {
        ProcessBuilder pbuilder = new ProcessBuilder(this.command).directory(this.workingDirectory);
        Map<String, String> environment = pbuilder.environment();
        String pathVarName = "PATH";
        String pathVarValue = environment.get(pathVarName);
        if (this.platform.isWindows()) {
            for (String key : environment.keySet()) {
                if (!"PATH".equalsIgnoreCase(key)) continue;
                pathVarName = key;
                pathVarValue = environment.get(key);
            }
        }
        StringBuilder pathBuilder = new StringBuilder();
        if (pathVarValue != null) {
            pathBuilder.append(pathVarValue).append(File.pathSeparator);
        }
        pathBuilder.append(this.workingDirectory + File.separator + "node").append(File.pathSeparator);
        pathBuilder.append(this.workingDirectory + File.separator + "node" + File.separator + "npm" + File.separator + "bin");
        environment.put(pathVarName, pathBuilder.toString());
        return pbuilder;
    }

    private static String readString(InputStream processInputStream) throws IOException {
        String line;
        BufferedReader inputStream = new BufferedReader(new InputStreamReader(processInputStream));
        StringBuilder result = new StringBuilder();
        while ((line = inputStream.readLine()) != null) {
            result.append(line).append("\n");
        }
        return result.toString().trim();
    }
}

