/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;

final class InputStreamHandler
extends Thread {
    private final InputStream inputStream;
    private final LogLevelAgnosticLogger logger;

    private InputStreamHandler(InputStream inputStream, LogLevelAgnosticLogger logger) {
        this.inputStream = inputStream;
        this.logger = logger;
    }

    public static InputStreamHandler logInfo(InputStream inputStream, Logger logger) {
        return new InputStreamHandler(inputStream, InputStreamHandler.infoLoggerFor(logger));
    }

    public static InputStreamHandler logError(InputStream inputStream, Logger logger) {
        return new InputStreamHandler(inputStream, InputStreamHandler.errorLoggerFor(logger));
    }

    @Override
    public void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.logger.log(line);
            }
        }
        catch (IOException e) {
            this.logger.log(e.getMessage());
        }
    }

    private static LogLevelAgnosticLogger infoLoggerFor(final Logger logger) {
        return new LogLevelAgnosticLogger(){

            @Override
            public void log(String value) {
                logger.info(value);
            }
        };
    }

    private static LogLevelAgnosticLogger errorLoggerFor(final Logger logger) {
        return new LogLevelAgnosticLogger(){

            @Override
            public void log(String value) {
                logger.error(value);
            }
        };
    }

    private static interface LogLevelAgnosticLogger {
        public void log(String var1);
    }
}

