/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.Architecture;
import com.github.eirslett.maven.plugins.frontend.lib.OS;

class Platform {
    private final OS os;
    private final Architecture architecture;

    public Platform(OS os, Architecture architecture) {
        this.os = os;
        this.architecture = architecture;
    }

    public static Platform guess() {
        OS os = OS.guess();
        Architecture architecture = Architecture.guess();
        return new Platform(os, architecture);
    }

    public String getCodename() {
        return this.os.getCodename();
    }

    public boolean isWindows() {
        return this.os == OS.Windows;
    }

    public boolean isMac() {
        return this.os == OS.Mac;
    }

    public String getLongNodeFilename(String nodeVersion) {
        if (this.isWindows()) {
            return "node.exe";
        }
        return "node-" + nodeVersion + "-" + this.getCodename() + "-" + this.architecture.toString();
    }

    public String getNodeDownloadFilename(String nodeVersion) {
        if (this.isWindows()) {
            if (this.architecture == Architecture.x64) {
                if (nodeVersion.startsWith("v0.")) {
                    return nodeVersion + "/x64/node.exe";
                }
                return nodeVersion + "/win-x64/node.exe";
            }
            if (nodeVersion.startsWith("v0.")) {
                return nodeVersion + "/node.exe";
            }
            return nodeVersion + "/win-x86/node.exe";
        }
        return nodeVersion + "/" + this.getLongNodeFilename(nodeVersion) + ".tar.gz";
    }
}

