/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultFileDownloader
implements FileDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDownloader.class);
    private final ProxyConfig proxyConfig;

    public DefaultFileDownloader(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Override
    public void download(String downloadUrl, String destination) throws DownloadException {
        String fixedDownloadUrl = downloadUrl;
        try {
            fixedDownloadUrl = FilenameUtils.separatorsToUnix((String)fixedDownloadUrl);
            URI downloadURI = new URI(fixedDownloadUrl);
            if ("file".equalsIgnoreCase(downloadURI.getScheme())) {
                FileUtils.copyFile((File)new File(downloadURI), (File)new File(destination));
            } else {
                CloseableHttpResponse response = this.execute(fixedDownloadUrl);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new DownloadException("Got error code " + statusCode + " from the server.");
                }
                new File(FilenameUtils.getFullPathNoEndSeparator((String)destination)).mkdirs();
                ReadableByteChannel rbc = Channels.newChannel(response.getEntity().getContent());
                FileOutputStream fos = new FileOutputStream(destination);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.close();
            }
        }
        catch (IOException e) {
            throw new DownloadException("Could not download " + fixedDownloadUrl, e);
        }
        catch (URISyntaxException e) {
            throw new DownloadException("Could not download " + fixedDownloadUrl, e);
        }
    }

    private CloseableHttpResponse execute(String requestUrl) throws IOException {
        ProxyConfig.Proxy proxy = this.proxyConfig.getProxyForUrl(requestUrl);
        if (proxy != null) {
            LOGGER.info("Downloading via proxy " + proxy.toString());
            return this.executeViaProxy(proxy, requestUrl);
        }
        LOGGER.info("No proxy was configured, downloading directly");
        CloseableHttpResponse response = this.buildHttpClient(null).execute((HttpUriRequest)new HttpGet(requestUrl));
        return response;
    }

    private CloseableHttpResponse executeViaProxy(ProxyConfig.Proxy proxy, String requestUrl) throws IOException {
        CloseableHttpClient proxyClient;
        if (proxy.useAuthentication()) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxy.host, proxy.port), (Credentials)new UsernamePasswordCredentials(proxy.username, proxy.password));
            proxyClient = this.buildHttpClient((CredentialsProvider)credentialsProvider);
        } else {
            proxyClient = this.buildHttpClient(null);
        }
        HttpHost proxyHttpHost = new HttpHost(proxy.host, proxy.port);
        RequestConfig requestConfig = RequestConfig.custom().setProxy(proxyHttpHost).build();
        HttpGet request = new HttpGet(requestUrl);
        request.setConfig(requestConfig);
        return proxyClient.execute((HttpUriRequest)request);
    }

    private CloseableHttpClient buildHttpClient(CredentialsProvider credentialsProvider) {
        return HttpClients.custom().disableContentCompression().useSystemProperties().setDefaultCredentialsProvider(credentialsProvider).build();
    }
}

