/*
 * Decompiled with CFR 0.152.
 */
package com.github.eloyzone.jalalicalendar;

import java.time.DateTimeException;

public enum MonthPersian {
    FARVARDIN,
    ORDIBEHESHT,
    KHORDAD,
    TIR,
    MORDAD,
    SHAHRIVAR,
    MEHR,
    ABAN,
    AZAR,
    DAY,
    BAHMAN,
    ESFAND;

    private static final MonthPersian[] ENUMS;
    static final String[] PERSIAN_MONTHS_EN;
    static final String[] PERSIAN_MONTHS_FA;

    public int getValue() {
        return this.ordinal() + 1;
    }

    public static MonthPersian getEnum(int value) {
        for (MonthPersian monthPersian : MonthPersian.values()) {
            if (monthPersian.ordinal() != value) continue;
            return monthPersian;
        }
        return null;
    }

    public String getStringInPersian() {
        return PERSIAN_MONTHS_FA[this.ordinal()];
    }

    public String getStringInEnglish() {
        return PERSIAN_MONTHS_EN[this.ordinal()];
    }

    public static MonthPersian of(int month) {
        if (month < 1 || month > 12) {
            throw new DateTimeException("Invalid value for MonthOfYear: " + month);
        }
        return ENUMS[month - 1];
    }

    static {
        ENUMS = MonthPersian.values();
        PERSIAN_MONTHS_EN = new String[]{"Farvardin", "Ordibehesht", "Khordad", "Tir", "Mordad", "Shahrivar", "Mehr", "Aban", "Azar", "Day", "Bahmand", "Esfand"};
        PERSIAN_MONTHS_FA = new String[]{"\u0641\u0631\u0648\u0631\u062f\u06cc\u0646", "\u0627\u0631\u062f\u06cc\u0628\u0647\u0634\u062a", "\u062e\u0631\u062f\u0627\u062f", "\u062a\u06cc\u0631", "\u0645\u0631\u062f\u0627\u062f", "\u0634\u0647\u0631\u06cc\u0648\u0631", "\u0645\u0647\u0631", "\u0622\u0628\u0627\u0646", "\u0622\u0630\u0631", "\u062f\u06cc", "\u0628\u0647\u0645\u0646", "\u0627\u0633\u0641\u0646\u062f"};
    }
}

