/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.everit.json.schema.loader.SchemaClient;

class ClassPathAwareSchemaClient
implements SchemaClient {
    private static final List<String> HANDLED_PREFIXES = Collections.unmodifiableList(Arrays.asList("classpath://", "classpath:/", "classpath:"));
    private final SchemaClient fallbackClient;

    ClassPathAwareSchemaClient(SchemaClient fallbackClient) {
        this.fallbackClient = Objects.requireNonNull(fallbackClient, "fallbackClient cannot be null");
    }

    @Override
    public InputStream get(String url) {
        return this.handleProtocol(url).map(this::loadFromClasspath).orElseGet(() -> this.fallbackClient.get(url));
    }

    private InputStream loadFromClasspath(String str) {
        return this.getClass().getResourceAsStream(str);
    }

    private Optional<String> handleProtocol(String url) {
        return HANDLED_PREFIXES.stream().filter(url::startsWith).map(prefix -> "/" + url.substring(prefix.length())).findFirst();
    }
}

