/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.List;
import java8.util.Objects;
import java8.util.Optional;
import java8.util.function.IntFunction;
import java8.util.stream.IntStream;
import java8.util.stream.IntStreams;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.ArraySchemaValidatingVisitor$$Lambda$1;
import org.everit.json.schema.ArraySchemaValidatingVisitor$$Lambda$2;
import org.everit.json.schema.ArraySchemaValidatingVisitor$$Lambda$3;
import org.everit.json.schema.ArraySchemaValidatingVisitor$$Lambda$4;
import org.everit.json.schema.ArraySchemaValidatingVisitor$$Lambda$5;
import org.everit.json.schema.ObjectComparator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidatingVisitor;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.Visitor;
import org.json.JSONArray;

class ArraySchemaValidatingVisitor
extends Visitor {
    private final Object subject;
    private final ValidatingVisitor owner;
    private JSONArray arraySubject;
    private ArraySchema arraySchema;
    private int subjectLength;

    public ArraySchemaValidatingVisitor(Object subject, ValidatingVisitor owner) {
        this.subject = subject;
        this.owner = (ValidatingVisitor)Objects.requireNonNull((Object)owner, (String)"owner cannot be null");
    }

    @Override
    void visitArraySchema(ArraySchema arraySchema) {
        if (this.owner.passesTypeCheck(JSONArray.class, arraySchema.requiresArray(), arraySchema.isNullable())) {
            this.arraySubject = (JSONArray)this.subject;
            this.subjectLength = this.arraySubject.length();
            this.arraySchema = arraySchema;
            super.visitArraySchema(arraySchema);
        }
    }

    @Override
    void visitMinItems(Integer minItems) {
        if (minItems != null && this.subjectLength < minItems) {
            this.owner.failure("expected minimum item count: " + minItems + ", found: " + this.subjectLength, "minItems");
        }
    }

    @Override
    void visitMaxItems(Integer maxItems) {
        if (maxItems != null && maxItems < this.subjectLength) {
            this.owner.failure("expected maximum item count: " + maxItems + ", found: " + this.subjectLength, "maxItems");
        }
    }

    @Override
    void visitUniqueItems(boolean uniqueItems) {
        if (!uniqueItems || this.subjectLength == 0) {
            return;
        }
        ArrayList<Object> uniques = new ArrayList<Object>(this.subjectLength);
        for (int i = 0; i < this.subjectLength; ++i) {
            Object item = this.arraySubject.get(i);
            for (Object e : uniques) {
                if (!ObjectComparator.deepEquals(e, item)) continue;
                this.owner.failure("array items are not unique", "uniqueItems");
                return;
            }
            uniques.add(item);
        }
    }

    @Override
    void visitAllItemSchema(Schema allItemSchema) {
        if (allItemSchema != null) {
            this.validateItemsAgainstSchema(IntStreams.range((int)0, (int)this.subjectLength), allItemSchema);
        }
    }

    @Override
    void visitItemSchema(int index, Schema itemSchema) {
        if (index >= this.subjectLength) {
            return;
        }
        Object subject = this.arraySubject.get(index);
        String idx = String.valueOf(index);
        Optional optional = this.ifFails(itemSchema, subject).map(ArraySchemaValidatingVisitor$$Lambda$1.lambdaFactory$(idx));
        ValidatingVisitor validatingVisitor = this.owner;
        validatingVisitor.getClass();
        optional.ifPresent(ArraySchemaValidatingVisitor$$Lambda$2.lambdaFactory$(validatingVisitor));
    }

    @Override
    void visitAdditionalItems(boolean additionalItems) {
        int itemSchemaCount;
        List<Schema> itemSchemas = this.arraySchema.getItemSchemas();
        int n = itemSchemaCount = itemSchemas == null ? 0 : itemSchemas.size();
        if (itemSchemas != null && !additionalItems && this.subjectLength > itemSchemaCount) {
            this.owner.failure(String.format("expected: [%d] array items, found: [%d]", itemSchemaCount, this.subjectLength), "items");
        }
    }

    @Override
    void visitSchemaOfAdditionalItems(Schema schemaOfAdditionalItems) {
        if (schemaOfAdditionalItems == null) {
            return;
        }
        int validationFrom = Math.min(this.subjectLength, this.arraySchema.getItemSchemas().size());
        this.validateItemsAgainstSchema(IntStreams.range((int)validationFrom, (int)this.subjectLength), schemaOfAdditionalItems);
    }

    private void validateItemsAgainstSchema(IntStream indices, Schema schema) {
        this.validateItemsAgainstSchema(indices, (IntFunction<Schema>)ArraySchemaValidatingVisitor$$Lambda$3.lambdaFactory$(schema));
    }

    private void validateItemsAgainstSchema(IntStream indices, IntFunction<Schema> schemaForIndex) {
        for (int i : indices.toArray()) {
            String copyOfI = String.valueOf(i);
            Optional optional = this.ifFails((Schema)schemaForIndex.apply(i), this.arraySubject.get(i)).map(ArraySchemaValidatingVisitor$$Lambda$4.lambdaFactory$(copyOfI));
            ValidatingVisitor validatingVisitor = this.owner;
            validatingVisitor.getClass();
            optional.ifPresent(ArraySchemaValidatingVisitor$$Lambda$5.lambdaFactory$(validatingVisitor));
        }
    }

    private Optional<ValidationException> ifFails(Schema schema, Object input) {
        return Optional.ofNullable((Object)this.owner.getFailureOfSchema(schema, input));
    }

    @Override
    void visitContainedItemSchema(Schema containedItemSchema) {
        if (containedItemSchema == null) {
            return;
        }
        for (int i = 0; i < this.arraySubject.length(); ++i) {
            Optional<ValidationException> exception = this.ifFails(containedItemSchema, this.arraySubject.get(i));
            if (exception.isPresent()) continue;
            return;
        }
        this.owner.failure("expected at least one array item to match 'contains' schema", "contains");
    }

    static /* synthetic */ ValidationException lambda$validateItemsAgainstSchema$2(String copyOfI, ValidationException exc) {
        return exc.prepend(copyOfI);
    }

    static /* synthetic */ Schema lambda$validateItemsAgainstSchema$1(Schema schema, int i) {
        return schema;
    }

    static /* synthetic */ ValidationException lambda$visitItemSchema$0(String idx, ValidationException exc) {
        return exc.prepend(idx);
    }
}

