/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.connection;

import com.jn.langx.util.Throwables;
import com.jn.sqlhelper.common.connection.ConnectionConfiguration;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory {
    private static Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private ConnectionConfiguration connectionConfiguration;

    public ConnectionFactory(String driver, String url, String user, String password, Properties driverProps) {
        this(new ConnectionConfiguration(driver, url, user, password, driverProps));
    }

    public ConnectionFactory(ConnectionConfiguration connConfig) {
        this.connectionConfiguration = connConfig;
        if (connConfig.getDriver() != null) {
            try {
                Class.forName(connConfig.getDriver(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw Throwables.wrapAsRuntimeException((Throwable)e);
            }
        }
    }

    public <T extends ConnectionConfiguration> void setConnectionConfiguration(T connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
    }

    public Connection getConnection() {
        try {
            if (this.connectionConfiguration.getDriver() != null) {
                try {
                    Class.forName(this.connectionConfiguration.getDriver(), true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.connectionConfiguration.getDriverProps() != null && !this.connectionConfiguration.getDriverProps().isEmpty()) {
                return DriverManager.getConnection(this.connectionConfiguration.getUrl(), this.connectionConfiguration.getDriverProps());
            }
            DriverManager.getConnection(this.connectionConfiguration.getUrl(), this.connectionConfiguration.getUser(), this.connectionConfiguration.getPassword());
        }
        catch (SQLException e) {
            logger.warn("Error occur when get connection with configuration: {}, error message : {}, stack:", new Object[]{this.connectionConfiguration.toString(), e.getMessage(), e});
        }
        return null;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }
}

