/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.datasource;

import com.jn.langx.text.StringTemplates;
import com.jn.sqlhelper.common.connection.ConnectionConfiguration;
import com.jn.sqlhelper.common.connection.ConnectionFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class SimpleDataSource
implements DataSource {
    private int loginTimeout = 0;
    private ConnectionFactory connectionFactory;

    @Override
    public Connection getConnection() throws SQLException {
        return this.connectionFactory.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        ConnectionConfiguration configuration = null;
        try {
            configuration = (ConnectionConfiguration)this.connectionFactory.getConnectionConfiguration().clone();
            return new ConnectionFactory(configuration).getConnection();
        }
        catch (CloneNotSupportedException ex) {
            return this.getConnection();
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException(StringTemplates.formatWithPlaceholder((String)"Class {} is not a wrapper", (Object[])new Object[]{SimpleDataSource.class}));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("global");
    }
}

