/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.ddl.dump;

import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.io.LineDelimiter;
import com.jn.langx.util.struct.Holder;
import com.jn.sqlhelper.common.ddl.dump.TableGenerator;
import com.jn.sqlhelper.common.ddl.model.Column;
import com.jn.sqlhelper.common.ddl.model.DatabaseDescription;
import com.jn.sqlhelper.common.ddl.model.ImportedColumn;
import com.jn.sqlhelper.common.ddl.model.Index;
import com.jn.sqlhelper.common.ddl.model.IndexColumn;
import com.jn.sqlhelper.common.ddl.model.PrimaryKeyColumn;
import com.jn.sqlhelper.common.ddl.model.Table;
import com.jn.sqlhelper.common.ddl.model.internal.BooleanFlag;
import com.jn.sqlhelper.common.ddl.model.internal.JdbcType;
import com.jn.sqlhelper.common.ddl.model.internal.SortType;
import com.jn.sqlhelper.common.ddl.model.internal.TableType;
import com.jn.sqlhelper.common.utils.SQLs;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public abstract class AbstractTableGenerator
implements TableGenerator {
    protected DatabaseDescription databaseDesc;

    public AbstractTableGenerator(DatabaseDescription databaseDesc) {
        this.databaseDesc = databaseDesc;
    }

    public AbstractTableGenerator(DatabaseMetaData dbMetaData) {
        this(new DatabaseDescription(dbMetaData));
    }

    @Override
    public String generate(Table table) throws SQLException {
        return this.generateAnyTableDDL(table);
    }

    protected boolean isSupportsSetPrimaryKeyInTableDDL() {
        return false;
    }

    protected boolean isSupportsSetPrimaryKeyUsingAlter() {
        return !this.isSupportsSetPrimaryKeyInTableDDL();
    }

    protected String generateAnyTableDDL(Table table) throws SQLException {
        TableType tableType = table.getTableType();
        if (tableType == TableType.SYSTEM_TABLE || tableType == TableType.TABLE || tableType == TableType.GLOBAL_TEMPORARY || tableType == TableType.LOCAL_TEMPORARY) {
            return this.buildTableDDL(table);
        }
        String lineDelimiter = LineDelimiter.DEFAULT.getValue();
        StringBuilder builder = new StringBuilder(256);
        String sql = table.getSql();
        if (Strings.isNotEmpty((String)sql)) {
            builder.append(sql);
            if (!sql.endsWith(";")) {
                builder.append(";");
            }
            builder.append(lineDelimiter);
        } else {
            if (tableType == TableType.ALIAS) {
                builder.append("CREATE ALIAS ");
            } else if (tableType == TableType.SYNONYM) {
                builder.append("CREATE SYNONYM ");
            } else {
                builder.append("CREATE VIEW ");
            }
            builder.append(table.getName()).append(";").append(lineDelimiter);
        }
        return builder.toString();
    }

    protected String buildTableDDL(final Table table) throws SQLException {
        final String lineDelimiter = LineDelimiter.DEFAULT.getValue();
        final StringBuilder builder = new StringBuilder(256);
        if (Strings.isEmpty((String)table.getSql())) {
            builder.append(this.buildCreateTableClause(table));
            builder.append("(").append(lineDelimiter);
            Collects.forEach(table.getColumns(), (Consumer2)new Consumer2<Integer, Column>(){

                public void accept(Integer i, Column column) {
                    if (i > 0) {
                        builder.append(",").append(lineDelimiter);
                    }
                    builder.append("\t").append(AbstractTableGenerator.this.buildDefineColumnClause(table, column));
                }
            });
            builder.append(lineDelimiter);
            Holder hasSetPrimaryKeys = new Holder((Object)false);
            Holder hasSetReferenceKeys = new Holder((Object)false);
            String afterAllColumnString = this.buildClausesAfterAllColumns(table, (Holder<Boolean>)hasSetPrimaryKeys, (Holder<Boolean>)hasSetReferenceKeys);
            if (Strings.isNotEmpty((String)afterAllColumnString)) {
                builder.append(",").append(afterAllColumnString);
            }
            builder.append(");").append(lineDelimiter);
            if (table.hasPrimaryKeys() && !((Boolean)hasSetPrimaryKeys.get()).booleanValue() && this.isSupportsSetPrimaryKeyUsingAlter()) {
                builder.append(this.buildAlterAddPrimaryKeyClause(table));
            }
        } else {
            String sql = table.getSql();
            builder.append(sql);
            if (!sql.endsWith(";")) {
                builder.append(";");
            }
            builder.append(lineDelimiter);
        }
        Collects.forEach(table.getIndexMap(), (Consumer2)new Consumer2<String, Index>(){

            public void accept(String key, Index index) {
                builder.append(AbstractTableGenerator.this.buildCreateIndexDDLClause(table, index));
            }
        });
        return builder.toString();
    }

    protected String buildCreateTableClause(Table table) throws SQLException {
        StringBuilder builder = new StringBuilder(256);
        builder.append("CREATE");
        TableType tableType = table.getTableType();
        if (tableType == TableType.GLOBAL_TEMPORARY || tableType == TableType.LOCAL_TEMPORARY) {
            builder.append(" ").append(tableType.getCode());
        }
        String tableFQN = this.getTableFQN(this.databaseDesc.supportsCatalogsInTableDefinitions() ? table.getCatalog() : null, this.databaseDesc.supportsSchemasInTableDefinitions() ? table.getSchema() : null, table.getName());
        builder.append(" TABLE ").append(tableFQN).append(LineDelimiter.DEFAULT.getValue());
        return builder.toString();
    }

    protected String buildDefineColumnClause(Table table, Column column) {
        ImportedColumn importedColumn;
        StringBuilder builder = new StringBuilder(256);
        builder.append(column.getName()).append(" ").append(column.getTypeName());
        JdbcType jdbcType = column.getJdbcType();
        if (jdbcType == JdbcType.VARCHAR || jdbcType == JdbcType.LONGVARCHAR || jdbcType == JdbcType.NVARCHAR || jdbcType == JdbcType.LONGNVARCHAR) {
            builder.append("(").append(column.getCharOctetLength()).append(")");
        } else if (jdbcType == JdbcType.CHAR) {
            builder.append("(").append(column.getSize()).append(")");
        }
        if (column.getIsNullable() == BooleanFlag.NO) {
            builder.append(" NOT NULL");
        }
        if (column.getDefaultValue() != null) {
            builder.append(" DEFAULT '").append(column.getDefaultValue()).append("'");
        }
        if (column.getIsAutoincrement() == BooleanFlag.YES) {
            builder.append(" AUTO_INCREMENT");
        }
        if (Strings.isNotEmpty((String)column.getRemarks())) {
            builder.append(" COMMENT '").append(column.getRemarks()).append("'");
        }
        if (jdbcType == JdbcType.REF && (importedColumn = table.getFkColumnMap().get(column.getName())) != null) {
            String tableFQN = this.getTableFQN(this.databaseDesc.supportsCatalogsInTableDefinitions() ? importedColumn.getPkTableCatalog() : null, this.databaseDesc.supportsSchemasInTableDefinitions() ? importedColumn.getPkTableSchema() : null, importedColumn.getPkTableName());
            builder.append(" REFERENCES ").append(tableFQN);
            builder.append(" (");
            builder.append(importedColumn.getPkColumnName());
            builder.append(")");
            if (importedColumn.getDeleteRule() != null) {
                builder.append(" ON DELETE ").append(importedColumn.getDeleteRule().getKeywords());
            }
            if (importedColumn.getUpdateRule() != null) {
                builder.append(" ON UPDATE ").append(importedColumn.getUpdateRule().getKeywords());
            }
        }
        return builder.toString();
    }

    protected String buildClausesAfterAllColumns(Table table, Holder<Boolean> hasSetPrimaryKeys, Holder<Boolean> hasSetReferenceKeys) {
        return "";
    }

    protected String buildAlterAddPrimaryKeyClause(Table table) throws SQLException {
        final StringBuilder builder = new StringBuilder(256);
        String tableFQN = this.getTableFQN(this.databaseDesc.supportsCatalogsInTableDefinitions() ? table.getCatalog() : null, this.databaseDesc.supportsSchemasInTableDefinitions() ? table.getSchema() : null, table.getName());
        builder.append("ALTER TABLE ").append(tableFQN).append(" ADD PRIMARY KEY (");
        Collects.forEach(table.getPkColumns(), (Consumer2)new Consumer2<Integer, PrimaryKeyColumn>(){

            public void accept(Integer i, PrimaryKeyColumn pkColumn) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(pkColumn.getColumnName());
            }
        });
        builder.append(");").append(LineDelimiter.DEFAULT.getValue());
        return builder.toString();
    }

    protected String buildCreateIndexDDLClause(Table table, Index index) {
        final StringBuilder builder = new StringBuilder(256);
        String tableFQN = this.getTableFQN(this.databaseDesc.supportsCatalogsInIndexDefinitions() ? table.getCatalog() : null, this.databaseDesc.supportsSchemasInIndexDefinitions() ? table.getSchema() : null, table.getName());
        builder.append("CREATE INDEX ").append(index.getName()).append(" ON ").append(tableFQN).append(" (");
        Collects.forEach(index.getColumns(), (Consumer2)new Consumer2<Integer, IndexColumn>(){

            public void accept(Integer i, IndexColumn indexColumn) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(indexColumn.getColumnName());
                if (indexColumn.getAscOrDesc() != SortType.UNSUPPORTED) {
                    builder.append(" ").append(indexColumn.getAscOrDesc().name());
                }
            }
        });
        builder.append(");").append(LineDelimiter.DEFAULT.getValue());
        return builder.toString();
    }

    protected String getTableFQN(String catalog, String schema, String tableName) {
        String catalogSeparator = this.databaseDesc.getCatalogSeparator();
        return SQLs.getTableFQN(catalog, schema, tableName, catalogSeparator, this.databaseDesc.isCatalogAtStart());
    }
}

