/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.ddl.model;

import com.jn.easyjson.core.JSONBuilderProvider;
import com.jn.langx.util.Preconditions;
import com.jn.sqlhelper.common.ddl.model.IndexColumn;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class Index {
    private String catalog;
    private String schema;
    private String tableName;
    private String name;
    private final Set<IndexColumn> indexColumns = new TreeSet<IndexColumn>(new Comparator<IndexColumn>(){

        @Override
        public int compare(IndexColumn c1, IndexColumn c2) {
            return c1.getOrdinalPosition() - c2.getOrdinalPosition();
        }
    });

    public Index() {
    }

    public Index(String table, String name) {
        this(null, null, table, name);
    }

    public Index(String catalog, String schema, String table, String name) {
        this.setCatalog(catalog);
        this.setSchema(schema);
        this.setTableName(table);
        this.setName(name);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String table) {
        Preconditions.checkNotNull((Object)table);
        this.tableName = table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Preconditions.checkNotNull((Object)name);
        this.name = name;
    }

    public Set<IndexColumn> getColumns() {
        return this.indexColumns;
    }

    public void addColumn(IndexColumn indexColumn) {
        this.indexColumns.add(indexColumn);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Index index = (Index)o;
        if (this.catalog != null ? !this.catalog.equals(index.catalog) : index.catalog != null) {
            return false;
        }
        if (this.schema != null ? !this.schema.equals(index.schema) : index.schema != null) {
            return false;
        }
        if (!this.tableName.equals(index.tableName)) {
            return false;
        }
        return this.name.equals(index.name);
    }

    public int hashCode() {
        int result = this.catalog != null ? this.catalog.hashCode() : 0;
        result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
        result = 31 * result + this.tableName.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return JSONBuilderProvider.create().serializeNulls(true).prettyFormat(true).build().toJson((Object)this);
    }
}

