/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.ddl.model;

import com.jn.easyjson.core.JSONBuilderProvider;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;
import com.jn.sqlhelper.common.ddl.model.Column;
import com.jn.sqlhelper.common.ddl.model.ImportedColumn;
import com.jn.sqlhelper.common.ddl.model.Index;
import com.jn.sqlhelper.common.ddl.model.PrimaryKeyColumn;
import com.jn.sqlhelper.common.ddl.model.internal.TableType;
import com.jn.sqlhelper.common.ddl.model.internal.TableTypeConverter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Table {
    @Nullable
    @com.jn.sqlhelper.common.annotation.Column(value={"TABLE_CAT", "TABLE_CATALOG"})
    private String catalog;
    @Nullable
    @com.jn.sqlhelper.common.annotation.Column(value={"TABLE_SCHEM", "TABLE_SCHEMA"})
    private String schema;
    @NonNull
    @com.jn.sqlhelper.common.annotation.Column(value={"TABLE_NAME"})
    private String name;
    @NonNull
    @com.jn.sqlhelper.common.annotation.Column(value={"TABLE_TYPE"}, converter=TableTypeConverter.class)
    private TableType tableType;
    @Nullable
    private String remarks;
    @com.jn.sqlhelper.common.annotation.Column(value={"TYPE_CAT"})
    private String typeCatalog;
    @com.jn.sqlhelper.common.annotation.Column(value={"TYPE_SCHEM"})
    private String typeSchema;
    private String typeName;
    @com.jn.sqlhelper.common.annotation.Column(value={"SELF_REFERENCING_COL_NAME"})
    private String selfReferencingColumnName;
    private String refGeneration;
    @Nullable
    private String sql;
    private final Map<String, Index> indexMap = new TreeMap<String, Index>(new Comparator<String>(){

        @Override
        public int compare(String key1, String key2) {
            return key1.compareToIgnoreCase(key2);
        }
    });
    private final Set<Column> columns = new TreeSet<Column>(new Comparator<Column>(){

        @Override
        public int compare(Column o1, Column o2) {
            return o1.getOrdinalPosition() - o2.getOrdinalPosition();
        }
    });
    private final Set<PrimaryKeyColumn> pkColumns = new TreeSet<PrimaryKeyColumn>(new Comparator<PrimaryKeyColumn>(){

        @Override
        public int compare(PrimaryKeyColumn o1, PrimaryKeyColumn o2) {
            return o1.getKeySeq() - o2.getKeySeq();
        }
    });
    private final Map<String, ImportedColumn> fkColumnMap = new HashMap<String, ImportedColumn>();

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TableType getTableType() {
        return this.tableType;
    }

    public void setTableType(TableType tableType) {
        this.tableType = tableType;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getTypeCatalog() {
        return this.typeCatalog;
    }

    public void setTypeCatalog(String typeCatalog) {
        this.typeCatalog = typeCatalog;
    }

    public String getTypeSchema() {
        return this.typeSchema;
    }

    public void setTypeSchema(String typeSchema) {
        this.typeSchema = typeSchema;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getSelfReferencingColumnName() {
        return this.selfReferencingColumnName;
    }

    public void setSelfReferencingColumnName(String selfReferencingColumnName) {
        this.selfReferencingColumnName = selfReferencingColumnName;
    }

    public String getRefGeneration() {
        return this.refGeneration;
    }

    public void setRefGeneration(String refGeneration) {
        this.refGeneration = refGeneration;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String toString() {
        return JSONBuilderProvider.create().prettyFormat(true).build().toJson((Object)this);
    }

    public Map<String, Index> getIndexMap() {
        return this.indexMap;
    }

    public Set<Column> getColumns() {
        return this.columns;
    }

    public void addIndex(Index index) {
        this.indexMap.put(index.getName(), index);
    }

    public Index getIndex(String indexName) {
        return this.indexMap.get(indexName);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public Column getColumn(final String columnName) {
        return (Column)Collects.findFirst(this.columns, (Predicate)new Predicate<Column>(){

            public boolean test(Column column) {
                return column.getName().equals(columnName);
            }
        });
    }

    public Set<PrimaryKeyColumn> getPkColumns() {
        return this.pkColumns;
    }

    public boolean hasPrimaryKeys() {
        return Emptys.isNotEmpty(this.pkColumns);
    }

    public void addPKColumn(PrimaryKeyColumn primaryKeyColumn) {
        this.pkColumns.add(primaryKeyColumn);
    }

    public Map<String, ImportedColumn> getFkColumnMap() {
        return this.fkColumnMap;
    }

    public void addFKColumn(ImportedColumn fkColumn) {
        this.fkColumnMap.put(fkColumn.getFkColumnName(), fkColumn);
    }
}

