/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.er;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.classparse.FieldInfo;
import com.jn.langx.util.reflect.classparse.FieldSetterAndGetterClassParser;
import com.jn.sqlhelper.common.annotation.Table;
import com.jn.sqlhelper.common.annotation.Tenant;
import com.jn.sqlhelper.common.er.EntityTableMapping;
import com.jn.sqlhelper.common.er.EntityTableParser;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.persistence.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntityTableMappingParser
implements EntityTableParser {
    private FieldSetterAndGetterClassParser setterAndGetterClassParser = new FieldSetterAndGetterClassParser();
    private static final Logger logger = LoggerFactory.getLogger(DefaultEntityTableMappingParser.class);

    public DefaultEntityTableMappingParser() {
        this.setterAndGetterClassParser.setHierachial(true);
    }

    @Override
    public EntityTableMapping parse(Class<?> entityClass) {
        Preconditions.checkNotNull(entityClass);
        EntityTableMapping mapping = new EntityTableMapping();
        this.parseTable(entityClass, mapping);
        return mapping;
    }

    private void parseTable(Class<?> entityClass, EntityTableMapping mapping) {
        Table table;
        if (Reflects.hasAnnotation(entityClass, Table.class) && Emptys.isNotEmpty((Object)(table = (Table)Reflects.getAnnotation(entityClass, Table.class)).value())) {
            mapping.setTable(table.value()[0]);
            return;
        }
        if (Emptys.isEmpty((Object)mapping.getTable()) && Reflects.hasAnnotation(entityClass, javax.persistence.Table.class) && Emptys.isNotEmpty((Object)(table = (javax.persistence.Table)Reflects.getAnnotation(entityClass, javax.persistence.Table.class)).name())) {
            mapping.setTable(table.name());
            return;
        }
        mapping.setTable(Reflects.getSimpleClassName(entityClass));
    }

    private void parseFields(Class<?> entityClass, final EntityTableMapping mapping) {
        Map fieldInfoMap = this.setterAndGetterClassParser.parse(entityClass);
        Collects.forEach((Map)fieldInfoMap, (Consumer2)new Consumer2<String, FieldInfo>(){

            public void accept(String fieldName, FieldInfo fieldInfo) {
                DefaultEntityTableMappingParser.this.parseField(fieldInfo, mapping);
            }
        });
    }

    private void parseField(FieldInfo fieldInfo, EntityTableMapping mapping) {
        this.parseAsColumn(fieldInfo, mapping);
        this.parseAsTenant(fieldInfo, mapping);
    }

    private void parseAsTenant(FieldInfo fieldInfo, EntityTableMapping mapping) {
        Method setter;
        Method getter;
        Field field = fieldInfo.getField();
        Tenant tenant = (Tenant)Reflects.getAnnotation((AnnotatedElement)field, Tenant.class);
        boolean isTenantColumn = false;
        if (tenant != null) {
            isTenantColumn = true;
        }
        if (!isTenantColumn && (getter = fieldInfo.getGetter()) != null && (tenant = (Tenant)Reflects.getAnnotation((AnnotatedElement)getter, Tenant.class)) != null) {
            isTenantColumn = true;
        }
        if (!isTenantColumn && (setter = fieldInfo.getSetter()) != null && (tenant = (Tenant)Reflects.getAnnotation((AnnotatedElement)setter, Tenant.class)) != null) {
            isTenantColumn = true;
        }
        if (isTenantColumn) {
            String fieldName = fieldInfo.getFieldName();
            if (Emptys.isEmpty((Object)mapping.getTenantField())) {
                mapping.setTenantField(fieldName);
            } else {
                logger.warn("Too may @Tenant in the class {}", (Object)Reflects.getFQNClassName(field.getDeclaringClass()));
            }
        }
    }

    private String parseColumnUseSqlhelperAnnotation(FieldInfo fieldInfo) {
        Method setter;
        Method getter;
        Field field = fieldInfo.getField();
        String columnName = null;
        com.jn.sqlhelper.common.annotation.Column column = (com.jn.sqlhelper.common.annotation.Column)Reflects.getAnnotation((AnnotatedElement)field, com.jn.sqlhelper.common.annotation.Column.class);
        if (column != null && Emptys.isNotEmpty((Object)column.value())) {
            columnName = column.value()[0];
        }
        if (Emptys.isEmpty(columnName) && (getter = fieldInfo.getGetter()) != null && (column = (com.jn.sqlhelper.common.annotation.Column)Reflects.getAnnotation((AnnotatedElement)getter, com.jn.sqlhelper.common.annotation.Column.class)) != null && Emptys.isNotEmpty((Object)column.value())) {
            columnName = column.value()[0];
        }
        if (Emptys.isEmpty(columnName) && (setter = fieldInfo.getSetter()) != null && (column = (com.jn.sqlhelper.common.annotation.Column)Reflects.getAnnotation((AnnotatedElement)setter, com.jn.sqlhelper.common.annotation.Column.class)) != null && Emptys.isNotEmpty((Object)column.value())) {
            columnName = column.value()[0];
        }
        return columnName;
    }

    private String parseColumnUsingJpaAnnotation(FieldInfo fieldInfo) {
        Field field = fieldInfo.getField();
        String columnName = null;
        if (Emptys.isEmpty(columnName)) {
            Method setter;
            Method getter;
            Column column = (Column)Reflects.getAnnotation((AnnotatedElement)field, Column.class);
            if (column != null && Emptys.isNotEmpty((Object)column.name())) {
                columnName = column.name();
            }
            if (Emptys.isEmpty(columnName) && (getter = fieldInfo.getGetter()) != null && (column = (Column)Reflects.getAnnotation((AnnotatedElement)getter, Column.class)) != null && Emptys.isNotEmpty((Object)column.name())) {
                columnName = column.name();
            }
            if (Emptys.isEmpty(columnName) && (setter = fieldInfo.getSetter()) != null && (column = (Column)Reflects.getAnnotation((AnnotatedElement)setter, Column.class)) != null && Emptys.isNotEmpty((Object)column.name())) {
                columnName = column.name();
            }
        }
        return columnName;
    }

    private void parseAsColumn(FieldInfo fieldInfo, EntityTableMapping mapping) {
        String fieldName = fieldInfo.getFieldName();
        String columnName = null;
        columnName = this.parseColumnUseSqlhelperAnnotation(fieldInfo);
        if (Emptys.isEmpty((Object)columnName)) {
            columnName = this.parseColumnUsingJpaAnnotation(fieldInfo);
        }
        mapping.getColumnMappings().put(fieldName, columnName);
    }
}

