/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.formatter;

import com.jn.langx.Formatter;
import com.jn.langx.util.Strings;
import com.jn.langx.util.io.LineDelimiter;
import java.util.Locale;
import java.util.StringTokenizer;

public class SqlDdlFormatter
implements Formatter<String, String> {
    private static final String INITIAL_LINE = LineDelimiter.DEFAULT.getValue() + "    ";
    private static final String OTHER_LINES = LineDelimiter.DEFAULT.getValue() + "       ";
    public static final SqlDdlFormatter INSTANCE = new SqlDdlFormatter();

    public String format(String sql, Object ... args) {
        return this.format(sql);
    }

    protected String format(String sql) {
        if (Strings.isEmpty((String)sql)) {
            return sql;
        }
        if (sql.toLowerCase(Locale.ROOT).startsWith("create table")) {
            return this.formatCreateTable(sql);
        }
        if (sql.toLowerCase(Locale.ROOT).startsWith("create")) {
            return sql;
        }
        if (sql.toLowerCase(Locale.ROOT).startsWith("alter table")) {
            return this.formatAlterTable(sql);
        }
        if (sql.toLowerCase(Locale.ROOT).startsWith("comment on")) {
            return this.formatCommentOn(sql);
        }
        return INITIAL_LINE + sql;
    }

    private String formatCommentOn(String sql) {
        StringBuilder result = new StringBuilder(60).append(INITIAL_LINE);
        StringTokenizer tokens = new StringTokenizer(sql, " '[]\"", true);
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            result.append(token);
            if (SqlDdlFormatter.isQuote(token)) {
                quoted = !quoted;
                continue;
            }
            if (quoted || !"is".equals(token)) continue;
            result.append(OTHER_LINES);
        }
        return result.toString();
    }

    private String formatAlterTable(String sql) {
        StringBuilder result = new StringBuilder(60).append(INITIAL_LINE);
        StringTokenizer tokens = new StringTokenizer(sql, " (,)'[]\"", true);
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (SqlDdlFormatter.isQuote(token)) {
                quoted = !quoted;
            } else if (!quoted && SqlDdlFormatter.isBreak(token)) {
                result.append(OTHER_LINES);
            }
            result.append(token);
        }
        return result.toString();
    }

    private String formatCreateTable(String sql) {
        StringBuilder result = new StringBuilder(60).append(INITIAL_LINE);
        StringTokenizer tokens = new StringTokenizer(sql, "(,)'[]\"", true);
        int depth = 0;
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (SqlDdlFormatter.isQuote(token)) {
                quoted = !quoted;
                result.append(token);
                continue;
            }
            if (quoted) {
                result.append(token);
                continue;
            }
            if (")".equals(token) && --depth == 0) {
                result.append(INITIAL_LINE);
            }
            result.append(token);
            if (",".equals(token) && depth == 1) {
                result.append(OTHER_LINES);
            }
            if (!"(".equals(token) || ++depth != 1) continue;
            result.append(OTHER_LINES);
        }
        return result.toString();
    }

    private static boolean isBreak(String token) {
        return "drop".equals(token) || "add".equals(token) || "references".equals(token) || "foreign".equals(token) || "on".equals(token);
    }

    private static boolean isQuote(String tok) {
        return "\"".equals(tok) || "`".equals(tok) || "]".equals(tok) || "[".equals(tok) || "'".equals(tok);
    }
}

