/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.common.resultset;

import com.jn.langx.Converter;
import com.jn.langx.exception.NoMappedFieldException;
import com.jn.langx.exception.ValueConvertException;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Objects;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.converter.ConverterService;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Modifiers;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.classparse.FieldInfo;
import com.jn.langx.util.reflect.type.Primitives;
import com.jn.sqlhelper.common.resultset.CachedEntityBeanClassParser;
import com.jn.sqlhelper.common.resultset.EntityBeanClassParser;
import com.jn.sqlhelper.common.resultset.EntityFieldInfo;
import com.jn.sqlhelper.common.resultset.ResultSetDescription;
import com.jn.sqlhelper.common.resultset.ResultSets;
import com.jn.sqlhelper.common.resultset.RowMapper;
import com.jn.sqlhelper.common.symbolmapper.SqlSymbolMapper;
import com.jn.sqlhelper.common.symbolmapper.UnderlineToCamelSymbolMapper;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanRowMapper<T>
implements RowMapper<T> {
    private static final Logger logger = LoggerFactory.getLogger(BeanRowMapper.class);
    private boolean ignoreUnrecognizableColumn = Boolean.parseBoolean(System.getProperty("beanrowmapper.ignoreUnrecognizableColumn", "false"));
    private Class<T> targetClass;
    private ConverterService converterService = ConverterService.DEFAULT;
    private SqlSymbolMapper sqlSymbolMapper;
    private Map<String, EntityFieldInfo> fieldMap;

    public BeanRowMapper(Class<T> beanClass) {
        this(beanClass, true);
    }

    public BeanRowMapper(Class<T> beanClass, boolean useCache) {
        Preconditions.checkNotNull(beanClass);
        this.targetClass = beanClass;
        this.fieldMap = (useCache ? CachedEntityBeanClassParser.getInstance() : new EntityBeanClassParser()).parse(this.targetClass);
    }

    @Override
    public T mapping(ResultSet row, int currentRowIndex, ResultSetDescription resultSetDescription) {
        if (this.sqlSymbolMapper == null) {
            this.sqlSymbolMapper = new UnderlineToCamelSymbolMapper();
        }
        int columnCount = resultSetDescription.getColumnCount();
        Object instance = Reflects.newInstance(this.targetClass);
        for (int i = 1; i <= columnCount; ++i) {
            Converter converter;
            String columnName = resultSetDescription.getColumnName(i);
            EntityFieldInfo fieldInfo = this.findFieldForColumn(columnName);
            if (fieldInfo == null) {
                if (this.ignoreUnrecognizableColumn) continue;
                String errorMessage = StringTemplates.formatWithPlaceholder((String)"Can't find a field link to a column: {} in the class: {}", (Object[])new Object[]{columnName, this.targetClass});
                throw new NoMappedFieldException(errorMessage);
            }
            Object value = null;
            try {
                value = ResultSets.getResultSetValue(row, i, fieldInfo.getFieldType());
            }
            catch (Throwable ex) {
                try {
                    value = ResultSets.getResultSetValue(row, i);
                }
                catch (Throwable ex2) {
                    throw Throwables.wrapAsRuntimeException((Throwable)ex2);
                }
            }
            if (value != null && !Primitives.wrap((Class)fieldInfo.getFieldType()).isAssignableFrom(value.getClass()) && (converter = fieldInfo.getConverter()) != null) {
                try {
                    value = converter.apply(value);
                }
                catch (Exception ex) {
                    logger.warn(ex.getMessage(), (Throwable)ex);
                    throw new ValueConvertException(StringTemplates.formatWithPlaceholder((String)"Can't convert {} to {} for {}#{}", (Object[])new Object[]{value.getClass(), fieldInfo.getFieldType(), Reflects.getFQNClassName(this.targetClass), fieldInfo.getFieldName()}));
                }
            }
            if (value != null && !Primitives.wrap((Class)fieldInfo.getFieldType()).isAssignableFrom(value.getClass()) && this.converterService != null) {
                try {
                    value = this.converterService.convert(value, fieldInfo.getFieldType());
                }
                catch (Throwable ex) {
                    logger.warn(ex.getMessage(), ex);
                    throw new ValueConvertException(StringTemplates.formatWithPlaceholder((String)"Can't convert {} to {} for {}#{}", (Object[])new Object[]{value.getClass(), fieldInfo.getFieldType(), Reflects.getFQNClassName(this.targetClass), fieldInfo.getFieldName()}));
                }
            }
            if (value != null && !Primitives.wrap((Class)fieldInfo.getFieldType()).isAssignableFrom(value.getClass())) {
                throw new ValueConvertException(StringTemplates.formatWithPlaceholder((String)"Can't convert {} to {} for {}#{}", (Object[])new Object[]{value.getClass(), fieldInfo.getFieldType(), Reflects.getFQNClassName(this.targetClass), fieldInfo.getFieldName()}));
            }
            try {
                this.setValue(fieldInfo, instance, value);
                continue;
            }
            catch (Throwable ex) {
                throw Throwables.wrapAsRuntimeException((Throwable)ex);
            }
        }
        return (T)instance;
    }

    private EntityFieldInfo findFieldForColumn(final String columnName) {
        if (this.fieldMap == null) {
            return null;
        }
        EntityFieldInfo fieldInfo = this.fieldMap.get(columnName);
        if (fieldInfo != null) {
            return fieldInfo;
        }
        fieldInfo = (EntityFieldInfo)((Object)Collects.findFirst(this.fieldMap.values(), (Predicate)new Predicate<EntityFieldInfo>(){

            public boolean test(EntityFieldInfo field) {
                return Collects.anyMatch(field.getColumnNames(), (Predicate)new Predicate<String>(){

                    public boolean test(String value) {
                        if (value.equalsIgnoreCase(columnName)) {
                            return true;
                        }
                        if (BeanRowMapper.this.sqlSymbolMapper != null) {
                            return ((String)BeanRowMapper.this.sqlSymbolMapper.apply(columnName)).equalsIgnoreCase((String)BeanRowMapper.this.sqlSymbolMapper.apply(value));
                        }
                        return false;
                    }
                });
            }
        }));
        if (fieldInfo != null) {
            this.fieldMap.put(columnName, fieldInfo);
        }
        return fieldInfo;
    }

    private void setValue(FieldInfo fieldInfo, Object target, Object fieldValue) throws Throwable {
        Method method = fieldInfo.getSetter();
        boolean valueIsNull = Objects.isNull((Object)fieldValue);
        if (method != null && Modifiers.isPublic((Member)method)) {
            boolean willInvoke = true;
            if (valueIsNull) {
                boolean bl = willInvoke = !Primitives.isPrimitive(method.getParameterTypes()[0]);
            }
            if (willInvoke) {
                method.setAccessible(true);
                try {
                    method.invoke(target, fieldValue);
                }
                catch (Throwable ex) {
                    logger.error("set {} # {} field by setter {} fail, value: {}", new Object[]{Reflects.getFQNClassName(this.targetClass), fieldInfo.getField().getName(), method.getName(), fieldValue});
                }
            }
        } else {
            boolean willInvoke = true;
            if (valueIsNull) {
                boolean bl = willInvoke = !Primitives.isPrimitive((Type)fieldInfo.getFieldType());
            }
            if (willInvoke) {
                fieldInfo.getField().setAccessible(true);
                try {
                    fieldInfo.getField().set(target, fieldValue);
                }
                catch (Throwable ex) {
                    logger.error("set {} # {} field by reflection fail, value: {}", new Object[]{Reflects.getFQNClassName(this.targetClass), fieldInfo.getField().getName(), fieldValue});
                }
            }
        }
    }

    public boolean isIgnoreUnrecognizableColumn() {
        return this.ignoreUnrecognizableColumn;
    }

    public void setIgnoreUnrecognizableColumn(boolean ignoreUnrecognizableColumn) {
        this.ignoreUnrecognizableColumn = ignoreUnrecognizableColumn;
    }

    public ConverterService getConverterService() {
        return this.converterService;
    }

    public void setConverterService(ConverterService converterService) {
        this.converterService = converterService;
    }

    public void setSqlSymbolMapper(SqlSymbolMapper sqlSymbolMapper) {
        this.sqlSymbolMapper = sqlSymbolMapper;
    }
}

