/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource;

import com.jn.langx.Delegatable;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.cluster.loadbalance.LoadBalancer;
import com.jn.langx.cluster.loadbalance.LoadBalancerAware;
import com.jn.langx.registry.Registry;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.logging.Level;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.pattern.patternset.AntPathMatcher;
import com.jn.langx.util.struct.Holder;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import com.jn.sqlhelper.datasource.key.parser.DataSourceKeyDataSourceParser;
import com.jn.sqlhelper.datasource.key.parser.RandomDataSourceKeyParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceRegistry
implements Registry<DataSourceKey, DataSource>,
LoadBalancerAware {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceRegistry.class);
    private volatile DataSourceKey primary = null;
    private ConcurrentHashMap<DataSourceKey, NamedDataSource> dataSourceRegistry = new ConcurrentHashMap();
    private DataSourceKeyDataSourceParser keyParser = RandomDataSourceKeyParser.INSTANCE;
    private LoadBalancer loadBalancer;
    private Set<DataSourceKey> nonExistDSKeys = new CopyOnWriteArraySet<DataSourceKey>();
    private volatile boolean failover = true;
    private Set<DataSourceKey> failKeys = new CopyOnWriteArraySet<DataSourceKey>();

    public void register(DataSourceKey key, DataSource dataSource) {
        Preconditions.checkNotEmpty((Object)key, (String)"the jdbc datasource key is null or empty");
        Preconditions.checkArgument((boolean)key.isAvailable(), (String)"the jdbc datasource key is invalid: {}", (Object[])new Object[]{key});
        Preconditions.checkNotNull((Object)dataSource);
        this.dataSourceRegistry.put(key, DataSources.toNamedDataSource(dataSource, key));
        if (this.primary == null && "primary".equals(key.getGroup())) {
            this.primary = key;
        }
        if (this.primary != null) {
            if (DataSources.DATASOURCE_PRIMARY.equals(key)) {
                this.primary = key;
            }
            if (!DataSources.DATASOURCE_PRIMARY.equals(this.primary)) {
                this.primary = new DataSourceKey("primary", "*");
            }
        }
    }

    public void register(DataSource dataSource) {
        NamedDataSource namedDataSource = this.wrap(dataSource);
        this.register(namedDataSource.getDataSourceKey(), namedDataSource);
    }

    public NamedDataSource get(DataSourceKey key) {
        if (key == null) {
            return null;
        }
        return this.dataSourceRegistry.get(key);
    }

    public List<DataSourceKey> findKeys(DataSourceKey keyPattern) {
        Preconditions.checkNotNull((Object)keyPattern);
        Preconditions.checkArgument((boolean)keyPattern.isAvailable(), (String)"the key is invalid: {}", (Object[])new Object[]{keyPattern});
        NamedDataSource namedDataSource = this.get(keyPattern);
        if (namedDataSource != null) {
            return Collects.newArrayList((Object[])new DataSourceKey[]{keyPattern});
        }
        if (this.nonExistDSKeys.contains(keyPattern)) {
            return Collections.emptyList();
        }
        String name = keyPattern.getName();
        if (!name.contains("*")) {
            this.addNonExistsDataSourceKey(keyPattern);
            return Collections.emptyList();
        }
        final AntPathMatcher antPathMatcher = new AntPathMatcher(null);
        antPathMatcher.setGlobal(true);
        antPathMatcher.setPatternExpression(name);
        final String group = keyPattern.getGroup();
        List matched = Pipeline.of((Iterable)this.dataSourceRegistry.keySet()).filter((Predicate)new Predicate<DataSourceKey>(){

            public boolean test(DataSourceKey dataSourceKey) {
                if (!dataSourceKey.getGroup().equals(group)) {
                    return false;
                }
                return antPathMatcher.match(dataSourceKey.getName());
            }
        }).asList();
        if (Emptys.isEmpty((Object)matched)) {
            this.addNonExistsDataSourceKey(keyPattern);
            return Collections.emptyList();
        }
        if (this.failover) {
            matched = Pipeline.of((Iterable)matched).filter((Predicate)new Predicate<DataSourceKey>(){

                public boolean test(DataSourceKey dataSourceKey) {
                    return !DataSourceRegistry.this.failKeys.contains(dataSourceKey);
                }
            }).asList();
        }
        return matched;
    }

    private void addNonExistsDataSourceKey(DataSourceKey keyPattern) {
        Loggers.log((int)3, (Logger)logger, (Level)Level.WARN, null, (String)"Using a key that is not exist: {}", (Object[])new Object[]{keyPattern});
        this.nonExistDSKeys.add(keyPattern);
    }

    private DataSourceKey intervalParse(@NonNull DataSource dataSource) {
        final ArrayList toComparedDataSourceList = Collects.newArrayList((Object[])new DataSource[0]);
        DataSource tmpDs = dataSource;
        while (tmpDs != null) {
            Object delegate;
            if (tmpDs instanceof NamedDataSource) {
                return ((NamedDataSource)tmpDs).getDataSourceKey();
            }
            toComparedDataSourceList.add(tmpDs);
            if (!(tmpDs instanceof Delegatable) || !((delegate = ((Delegatable)tmpDs).getDelegate()) instanceof DataSource)) break;
            tmpDs = (DataSource)delegate;
        }
        final Holder dataSourceKeyHolder = new Holder();
        Collects.forEach(this.dataSourceRegistry, (Consumer2)new Consumer2<DataSourceKey, NamedDataSource>(){

            public void accept(DataSourceKey key, final NamedDataSource ds) {
                if (Collects.anyMatch((Collection)toComparedDataSourceList, (Predicate)new Predicate<DataSource>(){

                    public boolean test(DataSource toCompared) {
                        DataSource delegateDs;
                        Object delegate;
                        if (ds == toCompared) {
                            return true;
                        }
                        return ds instanceof Delegatable && (delegate = ((Delegatable)ds).getDelegate()) instanceof DataSource && (delegateDs = (DataSource)delegate) == toCompared;
                    }
                })) {
                    dataSourceKeyHolder.set((Object)key);
                }
            }
        }, (Predicate2)new Predicate2<DataSourceKey, NamedDataSource>(){

            public boolean test(DataSourceKey key, NamedDataSource value) {
                return !dataSourceKeyHolder.isNull();
            }
        });
        return (DataSourceKey)dataSourceKeyHolder.get();
    }

    public void setKeyParser(DataSourceKeyDataSourceParser keyParser) {
        this.keyParser = keyParser;
    }

    public NamedDataSource wrap(DataSource dataSource) {
        DataSourceKey key = null;
        if (dataSource instanceof NamedDataSource) {
            key = ((NamedDataSource)dataSource).getDataSourceKey();
        }
        if (key == null) {
            key = this.intervalParse(dataSource);
        }
        if (key == null && this.keyParser != null) {
            key = this.keyParser.parse(dataSource);
        }
        if (key == null) {
            key = RandomDataSourceKeyParser.INSTANCE.parse(dataSource);
        }
        return DataSources.toNamedDataSource(dataSource, key);
    }

    public DataSourceKey getPrimary() {
        if (this.primary == null) {
            if (this.dataSourceRegistry.isEmpty()) {
                throw new IllegalStateException("Can't find any valid jdbc datasource");
            }
            if (this.dataSourceRegistry.size() == 1) {
                return (DataSourceKey)Collects.findFirst((Collection)this.dataSourceRegistry.keySet());
            }
            throw new IllegalStateException(StringTemplates.formatWithPlaceholder((String)"Can't find the primary jdbc datasource, all the registered dataSources: {}", (Object[])new Object[]{Strings.join((String)", ", (Iterable)this.dataSourceRegistry.keySet())}));
        }
        return this.primary;
    }

    public int size() {
        return this.dataSourceRegistry.size();
    }

    public boolean isFailover() {
        return this.failover;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public List<DataSourceKey> allKeys() {
        return Collects.asList((Iterable)this.dataSourceRegistry.keySet());
    }
}

