/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource;

import com.jn.langx.Named;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.sqlhelper.datasource.DelegatingNamedDataSource;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.SmartDataSource;
import com.jn.sqlhelper.datasource.definition.DataSourceProperties;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSources {
    private static final Logger logger = LoggerFactory.getLogger(DataSources.class);
    public static final String DATASOURCE_IMPLEMENT_KEY_TOMCAT = "tomcat";
    public static final String DATASOURCE_IMPLEMENT_KEY_HIKARICP = "hikaricp";
    public static final String DATASOURCE_IMPLEMENT_KEY_DRUID = "druid";
    public static final String DATASOURCE_IMPLEMENT_KEY_DBCP2 = "dbcp2";
    public static final String DATASOURCE_IMPLEMENT_KEY_C3P0 = "c3p0";
    public static final String DATASOURCE_PROP_IMPLEMENTATION = "datasource.implementation";
    public static final String DATASOURCE_PROP_GROUP = "datasource.group";
    public static final String DATASOURCE_PROP_NAME = "datasource.name";
    public static final String DATASOURCE_PRIMARY_GROUP = "primary";
    public static final String DATASOURCE_PRIMARY_NAME = "primary";
    public static final DataSourceKey DATASOURCE_PRIMARY = new DataSourceKey("primary", "primary");
    public static final String DATASOURCE_NAME_WILDCARD = "*";
    private static final int SQL_SERVER_SNAPSHOT_ISOLATION_LEVEL = 4096;
    public static List<String> TRANSACTION_ISOLATION_NAMES = Collects.newArrayList((Object[])new String[]{"NONE", "READ_COMMITTED", "READ_UNCOMMITTED", "REPEATABLE_READ", "SERIALIZABLE"});
    private static final String DATASOURCE_ID_SEPARATOR = "SQLHelper.DynamicDataSource.ID.separator";

    public static void releaseConnection(Connection con, DataSource dataSource) {
        try {
            DataSources.doReleaseConnection(con, dataSource);
        }
        catch (SQLException ex) {
            logger.debug("Could not close JDBC Connection", (Throwable)ex);
        }
        catch (Throwable ex) {
            logger.debug("Unexpected exception on closing JDBC Connection", ex);
        }
    }

    public static void doReleaseConnection(Connection con, DataSource dataSource) throws SQLException {
        if (con == null) {
            return;
        }
        DataSources.doCloseConnection(con, dataSource);
    }

    public static void doCloseConnection(Connection con, DataSource dataSource) throws SQLException {
        if (!(dataSource instanceof SmartDataSource) || ((SmartDataSource)dataSource).shouldClose(con)) {
            con.close();
        }
    }

    public static String getTransactionIsolation(String transactionIsolationName) {
        if (Strings.isBlank((String)transactionIsolationName)) {
            return null;
        }
        if ((transactionIsolationName = Strings.upperCase((String)transactionIsolationName, (Locale)Locale.ENGLISH)).startsWith("TRANSACTION_")) {
            transactionIsolationName = Strings.subSequence((CharSequence)transactionIsolationName, (int)"TRANSACTION_".length()).toString();
        }
        if (Strings.isBlank((String)transactionIsolationName)) {
            return null;
        }
        if (TRANSACTION_ISOLATION_NAMES.contains(transactionIsolationName)) {
            return transactionIsolationName;
        }
        return null;
    }

    public static int getTransactionIsolationInt(String transactionIsolationName) {
        if (transactionIsolationName != null) {
            try {
                String upperName = transactionIsolationName.toUpperCase(Locale.ENGLISH);
                if (upperName.startsWith("TRANSACTION_")) {
                    Field field = Connection.class.getField(upperName);
                    return field.getInt(null);
                }
                int level = Integer.parseInt(transactionIsolationName);
                switch (level) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: 
                    case 4096: {
                        return level;
                    }
                }
                throw new IllegalArgumentException();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid transaction isolation value: " + transactionIsolationName);
            }
        }
        return -1;
    }

    public static boolean isImplementationKeyMatched(@NonNull String expectedKey, DataSourceProperties properties) {
        Preconditions.checkNotNull((Object)expectedKey, (String)"the expected jdbc datasource implementation key is null or empty");
        String implementationKey = properties.getImplementation();
        boolean implementationKeyMatched = true;
        if (Emptys.isNotEmpty((Object)implementationKey) && !Objs.equals((Object)expectedKey, (Object)implementationKey)) {
            implementationKeyMatched = false;
        }
        return implementationKeyMatched;
    }

    public static final String getDatasourceIdSeparator() {
        return System.getProperty(DATASOURCE_ID_SEPARATOR, "/");
    }

    public static NamedDataSource toNamedDataSource(DataSource dataSource) {
        if (dataSource instanceof NamedDataSource) {
            return (NamedDataSource)dataSource;
        }
        String name = null;
        if (dataSource instanceof Named) {
            name = ((Named)dataSource).getName();
        }
        if (Strings.isBlank(name)) {
            name = UUID.randomUUID().toString();
        }
        return DataSources.toNamedDataSource(dataSource, name);
    }

    public static final NamedDataSource toNamedDataSource(@NonNull DataSource delegate, String name) {
        return DataSources.toNamedDataSource(delegate, null, name);
    }

    public static NamedDataSource toNamedDataSource(DataSource dataSource, DataSourceKey dataSourceKey) {
        return DataSources.toNamedDataSource(dataSource, dataSourceKey.getGroup(), dataSourceKey.getName());
    }

    public static final NamedDataSource toNamedDataSource(@NonNull DataSource delegate, @Nullable String group, @NonNull String name) {
        Preconditions.checkNotNull((Object)delegate, (String)"the delegate is null");
        Preconditions.checkNotEmpty((Object)name, (String)"the name is null or empty");
        group = Strings.useValueIfBlank((String)group, (String)"primary");
        if (delegate instanceof NamedDataSource) {
            NamedDataSource namedDataSource = (NamedDataSource)delegate;
            namedDataSource.setGroup(group);
            namedDataSource.setName(name);
            return namedDataSource;
        }
        DelegatingNamedDataSource dataSource = new DelegatingNamedDataSource();
        dataSource.setDelegate(delegate);
        dataSource.setName(name);
        dataSource.setGroup(group);
        return dataSource;
    }
}

