/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource;

import com.jn.langx.Delegatable;
import com.jn.langx.lifecycle.Initializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Preconditions;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DelegatingNamedDataSource
implements NamedDataSource,
Delegatable<DataSource>,
Initializable {
    private final DataSourceKey dataSourceKey = new DataSourceKey("primary", "undefined");
    private DataSource delegate;

    public DataSource getDelegate() {
        return this.delegate;
    }

    public void setDelegate(DataSource delegate) {
        Preconditions.checkNotNull((Object)delegate, (String)"'delegate' must not be null");
        this.delegate = delegate;
    }

    public DelegatingNamedDataSource() {
    }

    public DelegatingNamedDataSource(DataSource targetDataSource) {
        this.setDelegate(targetDataSource);
    }

    public void init() throws InitializationException {
        if (this.getDelegate() == null) {
            throw new InitializationException("Property 'targetDataSource' is required");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDelegate().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDelegate().getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDelegate().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDelegate().setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDelegate().getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDelegate().setLoginTimeout(seconds);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return this.getDelegate().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) || this.getDelegate().isWrapperFor(iface);
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger("global");
    }

    @Override
    public String getGroup() {
        return this.dataSourceKey.getGroup();
    }

    @Override
    public void setGroup(String group) {
        this.dataSourceKey.setGroup(group);
    }

    public void setName(String name) {
        this.dataSourceKey.setName(name);
    }

    public String getName() {
        return this.dataSourceKey.getName();
    }

    @Override
    public DataSourceKey getDataSourceKey() {
        return this.dataSourceKey;
    }
}

