/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.definition;

import com.jn.langx.configuration.Configuration;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Strings;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import java.util.Properties;

public class DataSourceProperties
implements Configuration {
    private String group = "primary";
    private String name;
    private String implementation;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private String catalog;
    private String schema;
    private boolean isReadOnly = false;
    private boolean isAutoCommit = true;
    private String transactionIsolation;
    private long leakDetectionThresholdInMills = 0L;
    private String validationQuery = null;
    private long connectionTimeoutInMills = 30000L;
    private long validationTimeoutInMills = 5000L;
    private long idleTimeoutInMills = 1800000L;
    private long maxLifetimeInMills = 1800000L;
    private int maxPoolSize = 10;
    private int initialSize = 0;
    private int minIdle = 10;
    private Properties driverProps;

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = Strings.getNullIfEmpty((String)catalog);
    }

    public long getLeakDetectionThresholdInMills() {
        return this.leakDetectionThresholdInMills;
    }

    public void setLeakDetectionThresholdInMills(long leakDetectionThresholdInMills) {
        this.leakDetectionThresholdInMills = leakDetectionThresholdInMills;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public long getConnectionTimeoutInMills() {
        return this.connectionTimeoutInMills;
    }

    public void setConnectionTimeoutInMills(long connectionTimeoutInMills) {
        this.connectionTimeoutInMills = connectionTimeoutInMills;
    }

    public long getValidationTimeoutInMills() {
        return this.validationTimeoutInMills;
    }

    public void setValidationTimeoutInMills(long validationTimeoutInMills) {
        this.validationTimeoutInMills = validationTimeoutInMills;
    }

    public long getIdleTimeoutInMills() {
        return this.idleTimeoutInMills;
    }

    public void setIdleTimeoutInMills(long idleTimeoutInMills) {
        this.idleTimeoutInMills = idleTimeoutInMills;
    }

    public long getMaxLifetimeInMills() {
        return this.maxLifetimeInMills;
    }

    public void setMaxLifetimeInMills(long maxLifetimeInMills) {
        this.maxLifetimeInMills = maxLifetimeInMills;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = Strings.getNullIfEmpty((String)driverClassName);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = Strings.getNullIfEmpty((String)url);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = Strings.getNullIfEmpty((String)username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = Strings.getNullIfEmpty((String)password);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Strings.getNullIfEmpty((String)name);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = Strings.getNullIfEmpty((String)schema);
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.isAutoCommit = autoCommit;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = Strings.getNullIfEmpty((String)validationQuery);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public String getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(String transactionIsolation) {
        this.transactionIsolation = Strings.getNullIfEmpty((String)transactionIsolation);
    }

    public Properties getDriverProps() {
        return this.driverProps;
    }

    public void setDriverProps(Properties driverProps) {
        this.driverProps = driverProps;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public String getId() {
        return this.group + DataSources.getDatasourceIdSeparator() + this.name;
    }

    public void setId(String idString) {
        String separator = DataSources.getDatasourceIdSeparator();
        if (!Strings.contains((CharSequence)idString, (CharSequence)separator)) {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder((String)"Illegal datasource id: {}", (Object[])new Object[]{"/"}));
        }
        int index = idString.indexOf(separator);
        if (index > 0) {
            String group = idString.substring(0, index);
            String name = idString.substring(index + separator.length());
            if (Strings.isNotBlank((String)group)) {
                this.setGroup(group);
            }
            if (Strings.isNotBlank((String)name)) {
                this.setName(name);
            }
        }
    }

    public DataSourceKey getDataSourceKey() {
        return new DataSourceKey(this.group, this.name);
    }
}

