/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.definition;

import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.multivalue.CommonMultiValueMap;
import com.jn.langx.util.collection.multivalue.MultiValueMap;
import com.jn.langx.util.function.Consumer2;
import com.jn.sqlhelper.datasource.definition.DataSourceProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourcesProperties {
    private static final Logger logger = LoggerFactory.getLogger(DataSourcesProperties.class);
    private boolean enabled;
    private List<DataSourceProperties> dataSources = Collects.emptyArrayList();
    private String defaultRouter;
    private MultiValueMap<String, String> groupRouters;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<DataSourceProperties> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(List<DataSourceProperties> dataSources) {
        this.dataSources = dataSources;
    }

    public String getDefaultRouter() {
        return this.defaultRouter;
    }

    public void setDefaultRouter(String defaultRouter) {
        this.defaultRouter = defaultRouter;
    }

    public void setGroupRouters(Map<String, String> mapping) {
        this.groupRouters = new CommonMultiValueMap();
        Collects.forEach(mapping, (Consumer2)new Consumer2<String, String>(){

            public void accept(String group, String routerString) {
                if (Strings.isBlank((String)routerString)) {
                    logger.warn("the routers string is blank for the group: {}", (Object)group);
                } else {
                    DataSourcesProperties.this.groupRouters.addAll((Object)group, (Collection)Collects.asList((Object[])Strings.split((String)routerString, (String)",")));
                }
            }
        });
    }

    public MultiValueMap<String, String> getGroupRouters() {
        return this.groupRouters;
    }
}

