/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.factory;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.datasource.DataSourceRegistry;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.definition.DataSourceProperties;
import com.jn.sqlhelper.datasource.factory.DataSourceFactory;
import com.jn.sqlhelper.datasource.factory.DataSourceFactoryProvider;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentralizedDataSourceFactory
implements DataSourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(CentralizedDataSourceFactory.class);
    private DataSourceRegistry registry;

    public DataSourceRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(DataSourceRegistry registry) {
        this.registry = registry;
    }

    @Override
    public NamedDataSource get(DataSourceProperties dataSourceProperties) {
        Preconditions.checkNotNull((Object)this.registry);
        String name = dataSourceProperties.getName();
        Preconditions.checkNotNull((Object)name, (String)"the datasource name is null");
        DataSourceKey key = dataSourceProperties.getDataSourceKey();
        NamedDataSource dataSource = this.registry.get(dataSourceProperties.getDataSourceKey());
        if (dataSource == null) {
            String implementationKey = dataSourceProperties.getImplementation();
            DataSourceFactory delegate = DataSourceFactoryProvider.getInstance().findSuitableDataSourceFactory(implementationKey, key);
            logger.info("Create jdbc datasource {} with the factory: {}", (Object)key, (Object)Reflects.getFQNClassName(delegate.getClass()));
            dataSource = delegate.get(dataSourceProperties);
            if (dataSource != null) {
                this.registry.register(key, dataSource);
                dataSource = this.registry.get(key);
            }
        }
        return dataSource;
    }

    @Override
    public NamedDataSource get(Properties properties) {
        Preconditions.checkNotNull((Object)this.registry);
        String name = properties.getProperty("datasource.name");
        Preconditions.checkNotNull((Object)name, (String)"the datasource name is null");
        String group = properties.getProperty("datasource.group", "primary");
        DataSourceKey key = new DataSourceKey(group, name);
        NamedDataSource dataSource = this.registry.get(key);
        if (dataSource == null) {
            String implementationKey = properties.getProperty("datasource.implementation");
            DataSourceFactory delegate = DataSourceFactoryProvider.getInstance().findSuitableDataSourceFactory(implementationKey, key);
            dataSource = delegate.get(properties);
            if (dataSource != null) {
                this.registry.register(key, dataSource);
                dataSource = this.registry.get(key);
            }
        }
        return dataSource;
    }
}

