/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.factory;

import com.jn.langx.annotation.Name;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.annotation.OnClasses;
import com.jn.langx.annotation.Singleton;
import com.jn.langx.factory.Provider;
import com.jn.langx.lifecycle.Initializable;
import com.jn.langx.util.ClassLoaders;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.datasource.factory.DataSourceFactory;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class DataSourceFactoryProvider
implements Provider<String, DataSourceFactory>,
Supplier0<DataSourceFactory>,
Initializable {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFactoryProvider.class);
    private static final ConcurrentHashMap<String, DataSourceFactory> registry = new ConcurrentHashMap();
    private static final DataSourceFactoryProvider INSTANCE = new DataSourceFactoryProvider();
    private static final String IMPLEMENTATION_JARS = "\n\t1) HikariCP.jar\t2) tomcat-jdbc.jar\t3) commons-dbcp2.jar\t4) druid.jar\t5) c3p0.jar";

    private DataSourceFactoryProvider() {
        this.init();
    }

    public void init() {
        ServiceLoader<DataSourceFactory> factoryLoader = ServiceLoader.load(DataSourceFactory.class);
        Collects.forEach(factoryLoader, (Consumer)new Consumer<DataSourceFactory>(){

            public void accept(DataSourceFactory dataSourceFactory) {
                Object[] requiredDependencyClasses;
                if (dataSourceFactory == null) {
                    return;
                }
                Class<?> dsClass = dataSourceFactory.getClass();
                if (!Reflects.isAnnotationPresent(dsClass, Name.class)) {
                    logger.warn("Couldn't found the annotation com.jn.langx.annotation.@Name at the class {}", (Object)Reflects.getFQNClassName(dsClass));
                    return;
                }
                Name nameAnno = (Name)Reflects.getAnnotation(dsClass, Name.class);
                String implementationKey = nameAnno.value();
                if (Emptys.isEmpty((Object)implementationKey)) {
                    logger.warn("Couldn't found a valid annotation com.jn.langx.annotation.@Name at the class {}, the name is null or empty", (Object)Reflects.getFQNClassName(dsClass));
                }
                OnClasses onClasses = (OnClasses)Reflects.getAnnotation(dsClass, OnClasses.class);
                boolean available = true;
                if (onClasses != null && Emptys.isNotEmpty((Object)onClasses.value()) && !Collects.allMatch((Predicate)new Predicate<String>(){

                    public boolean test(String dependencyClass) {
                        return ClassLoaders.hasClass((String)dependencyClass, (ClassLoader)DataSourceFactoryProvider.class.getClassLoader());
                    }
                }, (Object[])(requiredDependencyClasses = onClasses.value()))) {
                    available = false;
                }
                if (available) {
                    DataSourceFactoryProvider.this.register(implementationKey, dataSourceFactory);
                } else {
                    logger.warn("Couldn't found the key classes : {}", (Object)Strings.join((String)",", (String[])onClasses.value()));
                }
            }
        });
    }

    public static DataSourceFactoryProvider getInstance() {
        return INSTANCE;
    }

    public void register(@NonNull String implementationKey, @NonNull DataSourceFactory dataSourceFactory) {
        Preconditions.checkNotNull((Object)implementationKey, (String)"the jdbc datasource implementation key is empty or null");
        Preconditions.checkNotNull((Object)implementationKey, (String)"the jdbc datasource factory key is null");
        registry.putIfAbsent(implementationKey, dataSourceFactory);
        logger.info("Register a jdbc dataSource factory: {}, {}", (Object)implementationKey, (Object)Reflects.getFQNClassName(dataSourceFactory.getClass()));
    }

    public DataSourceFactory get(String implementationKey) {
        Preconditions.checkNotNull((Object)implementationKey, (String)"the implementation is null");
        return registry.get(implementationKey);
    }

    public DataSourceFactory get() {
        DataSourceFactory dataSourceFactory = registry.get("hikaricp");
        if (dataSourceFactory == null) {
            dataSourceFactory = (DataSourceFactory)Collects.findFirst(registry.values());
        }
        return dataSourceFactory;
    }

    public DataSourceFactory findSuitableDataSourceFactory(@Nullable String implementationKey) {
        return this.findSuitableDataSourceFactory(implementationKey, null);
    }

    public DataSourceFactory findSuitableDataSourceFactory(@Nullable String implementationKey, @Nullable DataSourceKey key) {
        DataSourceFactory delegate = null;
        if (Emptys.isEmpty((Object)implementationKey)) {
            if (key != null) {
                logger.warn("The 'implementation' property is not set for your jdbc datasource {}, so will select automation", (Object)key);
            } else {
                logger.warn("The 'implementation' property is not set for one of your jdbc datasources, so will select automation");
            }
        } else {
            delegate = this.get(implementationKey);
            if (delegate == null) {
                logger.warn("Can't find the jdbc database factory: {}, so will select automation", (Object)implementationKey);
            }
        }
        if (delegate == null) {
            delegate = this.get();
        }
        if (delegate == null) {
            logger.error("Can't find any jdbc database factory");
            throw new IllegalStateException("Can't find any jdbc database factory, please check has any the supported database implementations in your classpath: \n\t1) HikariCP.jar\t2) tomcat-jdbc.jar\t3) commons-dbcp2.jar\t4) druid.jar\t5) c3p0.jar");
        }
        return delegate;
    }
}

