/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.factory.c3p0;

import com.jn.langx.util.Maths;
import com.jn.langx.util.Throwables;
import com.jn.sqlhelper.datasource.definition.DataSourceProperties;
import com.mchange.v2.c3p0.DataSources;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class C3p0DataSources {
    private C3p0DataSources() {
    }

    public static DataSource createDataSource(DataSourceProperties properties) {
        try {
            String schema;
            String driverClassName;
            String url;
            String password;
            String username;
            DataSource ds_unpooled = DataSources.unpooledDataSource((String)properties.getUrl(), (String)properties.getUsername(), (String)properties.getPassword());
            Properties props = properties.getDriverProps();
            if (props == null) {
                props = new Properties();
            }
            if ((username = properties.getUsername()) != null) {
                props.setProperty("username", username);
            }
            if ((password = properties.getPassword()) != null) {
                props.setProperty("password", password);
            }
            if ((url = properties.getUrl()) != null) {
                props.setProperty("url", url);
            }
            if ((driverClassName = properties.getDriverClassName()) != null) {
                props.setProperty("driverClassName", driverClassName);
            }
            props.setProperty("defaultAutoCommit", "" + properties.isAutoCommit());
            props.setProperty("defaultReadOnly", "" + properties.isReadOnly());
            props.setProperty("defaultTransactionIsolation", properties.getTransactionIsolation());
            String catalog = properties.getCatalog();
            if (catalog != null) {
                props.setProperty("defaultCatalog", catalog);
            }
            if ((schema = properties.getSchema()) != null) {
                props.setProperty("defaultSchema", schema);
            }
            props.setProperty("initialPoolSize", "" + properties.getInitialSize());
            props.setProperty("maxPoolSize", "" + Maths.max((int[])new int[]{8, properties.getMaxPoolSize()}));
            return DataSources.pooledDataSource((DataSource)ds_unpooled, (String)properties.getName(), (Map)props);
        }
        catch (Exception ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
    }

    public static DataSource createDataSource(Properties properties) {
        try {
            DataSource ds_unpooled = DataSources.unpooledDataSource();
            return DataSources.pooledDataSource((DataSource)ds_unpooled, (Properties)properties);
        }
        catch (Exception ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
    }
}

