/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.factory.dbcp2;

import com.jn.langx.util.Maths;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.definition.DataSourceProperties;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;

public class Dbcp2DataSources {
    private Dbcp2DataSources() {
    }

    public static DataSource createDataSource(DataSourceProperties properties) {
        String schema;
        String catalog;
        String driverClassName;
        String url;
        String password;
        String username;
        Properties props = properties.getDriverProps();
        if (props == null) {
            props = new Properties();
        }
        if ((username = properties.getUsername()) != null) {
            props.setProperty("username", username);
        }
        if ((password = properties.getPassword()) != null) {
            props.setProperty("password", password);
        }
        if ((url = properties.getUrl()) != null) {
            props.setProperty("url", url);
        }
        if ((driverClassName = properties.getDriverClassName()) != null) {
            props.setProperty("driverClassName", driverClassName);
        }
        props.setProperty("autoCommitOnClose", "" + properties.isAutoCommit());
        props.setProperty("defaultReadOnly", "" + properties.isReadOnly());
        String transactionIsolation = DataSources.getTransactionIsolation(properties.getTransactionIsolation());
        if (Strings.isNotBlank((String)transactionIsolation)) {
            props.setProperty("defaultTransactionIsolation", transactionIsolation);
        }
        if ((catalog = properties.getCatalog()) != null) {
            props.setProperty("defaultCatalog", catalog);
        }
        if ((schema = properties.getSchema()) != null) {
            props.setProperty("defaultSchema", schema);
        }
        props.setProperty("initialSize", "" + properties.getInitialSize());
        props.setProperty("minIdle", "" + properties.getMinIdle());
        props.setProperty("maxIdle", "" + Maths.max((int[])new int[]{8, properties.getMinIdle()}));
        props.setProperty("maxTotal", "" + Maths.max((int[])new int[]{8, properties.getMaxPoolSize()}));
        String validationQuery = properties.getValidationQuery();
        if (validationQuery != null) {
            props.setProperty("validationQuery", validationQuery);
        }
        props.setProperty("maxConnLifetimeMillis", "" + properties.getMaxLifetimeInMills());
        try {
            return Dbcp2DataSources.createDataSource(props);
        }
        catch (Exception ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
    }

    public static DataSource createDataSource(Properties props) {
        try {
            return BasicDataSourceFactory.createDataSource((Properties)props);
        }
        catch (Exception ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
    }
}

