/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.factory.druid;

import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.definition.DataSourceProperties;
import java.util.Properties;
import javax.sql.DataSource;

public class AlibabaDruidDataSources {
    private AlibabaDruidDataSources() {
    }

    public static DataSource createDataSource(DataSourceProperties properties) {
        String catalog;
        String driverClassName;
        String url;
        String password;
        String username;
        Properties props = properties.getDriverProps();
        if (props == null) {
            props = new Properties();
        }
        if ((username = properties.getUsername()) != null) {
            props.setProperty("username", username);
        }
        if ((password = properties.getPassword()) != null) {
            props.setProperty("password", password);
        }
        if ((url = properties.getUrl()) != null) {
            props.setProperty("url", url);
        }
        if ((driverClassName = properties.getDriverClassName()) != null) {
            props.setProperty("driverClassName", driverClassName);
        }
        props.setProperty("defaultAutoCommit", "" + properties.isAutoCommit());
        props.setProperty("defaultReadOnly", "" + properties.isReadOnly());
        String transactionIsolation = DataSources.getTransactionIsolation(properties.getTransactionIsolation());
        if (Strings.isNotBlank((String)transactionIsolation)) {
            props.setProperty("defaultTransactionIsolation", transactionIsolation);
        }
        if ((catalog = properties.getCatalog()) != null) {
            props.setProperty("defaultCatalog", catalog);
        }
        props.setProperty("initialSize", "" + properties.getInitialSize());
        props.setProperty("minIdle", "" + properties.getMinIdle());
        props.setProperty("maxIdle", "" + Maths.max((int[])new int[]{8, properties.getMinIdle()}));
        props.setProperty("maxActive", "" + Maths.max((int[])new int[]{8, properties.getMaxPoolSize()}));
        String validationQuery = properties.getValidationQuery();
        if (validationQuery != null) {
            props.setProperty("validationQuery", validationQuery);
        }
        try {
            return AlibabaDruidDataSources.createDataSource(props);
        }
        catch (Exception ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
    }

    public static DataSource createDataSource(Properties properties) {
        try {
            return DruidDataSourceFactory.createDataSource((Properties)properties);
        }
        catch (Exception ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
    }
}

