/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.factory.hikaricp;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.Strings;
import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.definition.DataSourceProperties;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariDataSources {
    private static final Logger logger = LoggerFactory.getLogger(HikariDataSources.class);

    private HikariDataSources() {
    }

    public static DataSource createDataSource(DataSourceProperties props) {
        Properties driverProps = props.getDriverProps();
        HikariConfig config = null;
        config = Emptys.isNotEmpty((Object)driverProps) ? new HikariConfig(driverProps) : new HikariConfig();
        config.setDriverClassName(props.getDriverClassName());
        config.setJdbcUrl(props.getUrl());
        config.setUsername(props.getUsername());
        config.setPassword(props.getPassword());
        config.setPoolName(props.getName());
        config.setCatalog(props.getCatalog());
        Reflects.invokePublicMethod((Object)config, (String)"setSchema", (Class[])new Class[]{String.class}, (Object[])new Object[]{props.getSchema()}, (boolean)true, (boolean)false);
        config.setLeakDetectionThreshold(props.getLeakDetectionThresholdInMills());
        config.setConnectionTimeout(props.getConnectionTimeoutInMills());
        config.setValidationTimeout(props.getValidationTimeoutInMills());
        config.setConnectionInitSql(props.getValidationQuery());
        config.setIdleTimeout(props.getIdleTimeoutInMills());
        config.setMaxLifetime(props.getMaxLifetimeInMills());
        config.setMaximumPoolSize(props.getMaxPoolSize());
        config.setMinimumIdle(props.getMinIdle());
        config.setAutoCommit(props.isAutoCommit());
        String transactionIsolation = DataSources.getTransactionIsolation(props.getTransactionIsolation());
        if (Strings.isNotBlank((String)transactionIsolation)) {
            config.setTransactionIsolation("TRANSACTION_" + transactionIsolation);
        }
        config.setReadOnly(props.isReadOnly());
        return new HikariDataSource(config);
    }

    public static DataSource createDataSource(Properties props) {
        return new HikariDataSource(new HikariConfig(props));
    }
}

