/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.factory.hikaricp;

import com.jn.langx.annotation.Name;
import com.jn.langx.annotation.OnClasses;
import com.jn.langx.text.StringTemplates;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.definition.DataSourceProperties;
import com.jn.sqlhelper.datasource.factory.DataSourceFactory;
import com.jn.sqlhelper.datasource.factory.hikaricp.HikariDataSources;
import java.util.Properties;
import javax.sql.DataSource;

@Name(value="hikaricp")
@OnClasses(value={"com.zaxxer.hikari.HikariDataSource"})
public class HikaricpDataSourceFactory
implements DataSourceFactory {
    @Override
    public NamedDataSource get(DataSourceProperties dataSourceProperties) {
        if (DataSources.isImplementationKeyMatched("hikaricp", dataSourceProperties)) {
            DataSource dataSource = HikariDataSources.createDataSource(dataSourceProperties);
            String name = dataSourceProperties.getName();
            return DataSources.toNamedDataSource(dataSource, name);
        }
        throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder((String)"Illegal datasource implementationKey {}, expected key is {}", (Object[])new Object[]{dataSourceProperties.getImplementation(), "hikaricp"}));
    }

    @Override
    public NamedDataSource get(Properties properties) {
        DataSource dataSource = HikariDataSources.createDataSource(properties);
        String name = properties.getProperty("datasource.name");
        return DataSources.toNamedDataSource(dataSource, name);
    }
}

